/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import contrib.javapro.JSortTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import rero.config.ClientState;
import rero.gui.toolkit.GeneralListModel;
import rero.gui.windows.EmptyWindow;
import text.AttributedLabel;
import text.AttributedString;
import text.TextSource;

public class GeneralListDialog
extends EmptyWindow {
    protected GeneralListModel model;
    protected JSortTable table;
    protected String popupHook;
    protected String name;

    public GeneralListDialog(String _name, String _hook, GeneralListModel _model) {
        this.name = _name;
        this.popupHook = _hook;
        this.model = _model;
        this.setLayout(new BorderLayout());
        this.table = new JSortTable(this.model);
        this.table.setOpaque(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setDefaultRenderer(new Object().getClass(), new MyRenderer());
        this.table.setShowGrid(false);
        this.table.setSelectionMode(0);
        this.table.setRowHeight(TextSource.fontMetrics.getHeight() + 2);
        JScrollPane scroller = new JScrollPane(this.table, 22, 31);
        scroller.setOpaque(false);
        scroller.getViewport().setOpaque(false);
        scroller.setCorner("UPPER_RIGHT_CORNER", new JPanel());
        int x = 0;
        TableColumn tempcol = this.table.getColumnModel().getColumn(x);
        tempcol.setMinWidth(1);
        tempcol.setMaxWidth(this.model.getColumnWidth(x) * 3);
        tempcol.setPreferredWidth(this.model.getColumnWidth(x));
        for (x = 1; x < this.model.getColumnCount() - 1; ++x) {
            tempcol = this.table.getColumnModel().getColumn(x);
            tempcol.setMinWidth(1);
            tempcol.setMaxWidth(this.model.getColumnWidth(x) * 3);
            tempcol.sizeWidthToFit();
        }
        this.table.setRowSelectionAllowed(true);
        scroller.setViewportBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        this.add(scroller);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                int row = GeneralListDialog.this.table.rowAtPoint(p);
                int column = GeneralListDialog.this.table.columnAtPoint(p);
                GeneralListDialog.this.maybeShowPopup(e, GeneralListDialog.this.model.getEventHashMap(row));
            }

            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                int row = GeneralListDialog.this.table.rowAtPoint(p);
                int column = GeneralListDialog.this.table.columnAtPoint(p);
                GeneralListDialog.this.maybeShowPopup(e, GeneralListDialog.this.model.getEventHashMap(row));
                if (e.getClickCount() == 2 && !e.isPopupTrigger() && e.getButton() == 1 && !e.isConsumed()) {
                    GeneralListDialog.this.processMouseEvent(e, row);
                    e.consume();
                }
            }

            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                int row = GeneralListDialog.this.table.rowAtPoint(p);
                int column = GeneralListDialog.this.table.columnAtPoint(p);
                GeneralListDialog.this.maybeShowPopup(e, GeneralListDialog.this.model.getEventHashMap(row));
            }
        });
    }

    public void init() {
    }

    protected void maybeShowPopup(MouseEvent ev, HashMap data) {
        JPopupMenu menu = this.getPopupMenu(this.popupHook, data);
        if (ev.isPopupTrigger() && menu != null) {
            menu.show((JComponent)ev.getComponent(), ev.getX(), ev.getY());
            ev.consume();
        }
    }

    public String getName() {
        return this.name;
    }

    public ImageIcon getImageIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon(ClientState.getClientState().getResource("status.gif"));
        }
        return this.icon;
    }

    public void processMouseEvent(MouseEvent ev, int row) {
        this.fireClickEvent(row + "", ev);
    }

    private static class MyRenderer
    implements TableCellRenderer {
        private JLabel select = new JLabel();
        private AttributedLabel labeln = new AttributedLabel();
        private AttributedLabel labels = new AttributedLabel();

        public MyRenderer() {
            this.select.setOpaque(true);
            this.select.setLayout(new BorderLayout());
            this.select.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.select.add(this.labels);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return new JLabel();
            }
            AttributedString attrs = (AttributedString)value;
            if (isSelected) {
                this.select.setFont(TextSource.clientFont);
                this.select.setBackground(table.getSelectionBackground());
                this.select.setForeground(table.getSelectionForeground());
                this.select.setText(attrs.getText());
                return this.select;
            }
            this.labeln.setText(attrs);
            return this.labeln;
        }
    }
}

