/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import rero.bridges.menu.MenuBridge;
import rero.client.Capabilities;
import rero.gui.input.InputField;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.ClientWindowListener;
import rero.gui.windows.StatusWindow;
import rero.gui.windows.WindowStatusBar;
import text.WrappedDisplay;
import text.event.ClickEvent;
import text.event.ClickListener;

public abstract class EmptyWindow
extends StatusWindow
implements ClientWindowListener {
    private boolean isOpen = true;
    protected LinkedList listeners = new LinkedList();

    public void touch() {
    }

    public void installCapabilities(Capabilities c) {
        this.capabilities = c;
        this.menuManager = (MenuBridge)c.getDataStructure("menuBridge");
        this.init();
    }

    public InputField getInput() {
        return null;
    }

    public WrappedDisplay getDisplay() {
        return null;
    }

    public WindowStatusBar getStatusBar() {
        return null;
    }

    public void init(ClientWindow _frame) {
        this.frame = _frame;
        this.frame.addWindowListener(new StatusWindow.ClientWindowStuff(this));
        this.frame.addWindowListener(this);
        this.frame.setContentPane(this);
        this.setTitle(this.getName());
        this.frame.setIcon(this.getImageIcon());
    }

    public abstract void init();

    public String getQuery() {
        return "Nada";
    }

    public void setQuery(String q) {
    }

    public void setTitle(String title) {
        this.frame.setTitle(title);
    }

    public ClientWindow getWindow() {
        return this.frame;
    }

    public String getTitle() {
        return this.frame.getTitle();
    }

    public abstract String getName();

    public abstract ImageIcon getImageIcon();

    public String getWindowType() {
        return "Other";
    }

    public boolean isLegalWindow() {
        return false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void onActive(ClientWindowEvent ev) {
    }

    public void onOpen(ClientWindowEvent ev) {
        this.isOpen = true;
    }

    public void onInactive(ClientWindowEvent ev) {
    }

    public void onMinimize(ClientWindowEvent ev) {
    }

    public void onClose(ClientWindowEvent ev) {
        this.isOpen = false;
    }

    public void addClickListener(ClickListener l) {
        this.listeners.add(l);
    }

    public void fireClickEvent(String text, MouseEvent mev) {
        ClickEvent ev = new ClickEvent(text, this.getName(), mev);
        ListIterator i = this.listeners.listIterator();
        while (i.hasNext() && !ev.isConsumed()) {
            ClickListener l = (ClickListener)i.next();
            l.wordClicked(ev);
        }
    }

    public int compareWindowType() {
        return 4;
    }
}

