/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.util.HashMap;
import java.util.List;
import rero.client.output.OutputCapabilities;
import rero.dcc.DataDCC;
import rero.dcc.GenericDCC;
import rero.gui.toolkit.GeneralListModel;
import rero.gui.windows.GeneralListDialog;
import rero.ircfw.interfaces.ChatListener;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.util.TimerListener;
import text.AttributedString;

public class DCCListDialog
extends GeneralListDialog
implements TimerListener {
    public DCCListDialog() {
        super("DCC Sessions", "dcc", new DCCListModel());
    }

    public void timerExecute() {
        this.table.repaint();
    }

    public void init() {
        ((DCCListModel)this.model).installData((DataDCC)this.capabilities.getDataStructure("dcc"), this.capabilities.getOutputCapabilities());
        this.model.fireTableDataChanged();
        this.capabilities.getTimer().addTimer(this, 1000L);
        this.capabilities.addChatListener(new DCCListener());
    }

    public String getWindowType() {
        return "DCCStats";
    }

    private static class DCCListModel
    extends GeneralListModel {
        protected DataDCC data;
        protected OutputCapabilities output;

        private DCCListModel() {
        }

        public HashMap getEventHashMap(int row) {
            HashMap<String, String> event = new HashMap<String, String>();
            GenericDCC temp = (GenericDCC)this.getConnections().get(row);
            event.put("$this", temp.getImplementation().toString());
            return event;
        }

        public void installData(DataDCC d, OutputCapabilities o) {
            this.data = d;
            this.output = o;
        }

        public void sortColumn(int col, boolean ascending) {
            this.fireTableDataChanged();
        }

        private List getConnections() {
            return this.data.getConnections(-1, 402);
        }

        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.getConnections().size();
        }

        public int getColumnCount() {
            return 3;
        }

        public int getColumnWidth(int col) {
            if (col == 0) {
                return 75;
            }
            if (col == 1) {
                return 100;
            }
            return 400;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Type";
                }
                case 1: {
                    return "Nickname";
                }
                case 2: {
                    return "Information";
                }
                case 3: {
                    return "File";
                }
            }
            return "Unknown";
        }

        public Object getValueAt(int row, int col) {
            if (row >= this.getRowCount()) {
                return null;
            }
            HashMap temp = this.getEventHashMap(row);
            String text = "";
            switch (col) {
                case 0: {
                    text = this.output.parseSet(temp, "DCC_LIST_TYPE");
                    break;
                }
                case 1: {
                    text = this.output.parseSet(temp, "DCC_LIST_NICK");
                    break;
                }
                case 2: {
                    text = this.output.parseSet(temp, "DCC_LIST_INFORMATION");
                    break;
                }
                case 3: {
                    text = this.output.parseSet(temp, "DCC_LIST_FILE");
                }
            }
            AttributedString tempa = AttributedString.CreateAttributedString(text);
            tempa.assignWidths();
            return tempa;
        }

        public boolean isSortable(int col) {
            return false;
        }
    }

    private class DCCListener
    implements ChatListener,
    FrameworkConstants {
        private DCCListener() {
        }

        public boolean isChatEvent(String event, HashMap eventData) {
            return event.indexOf("CHAT_") > -1 || event.indexOf("SEND_") > -1 || event.indexOf("RECEIVE_") > -1;
        }

        public int fireChatEvent(HashMap data) {
            DCCListDialog.this.model.fireTableDataChanged();
            return 1;
        }
    }
}

