/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import rero.bridges.menu.ScriptedPopupMenu;
import rero.client.Capabilities;
import rero.config.ClientState;
import rero.gui.windows.ChannelListData;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.ListBoxOptions;
import rero.gui.windows.StatusWindow;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;
import rero.ircfw.User;
import rero.ircfw.interfaces.ChannelDataWatch;
import text.ListDisplay;
import text.event.ClickEvent;
import text.event.ClickListener;
import text.list.ListElement;

public class ChannelWindow
extends StatusWindow
implements ChannelDataWatch {
    protected Channel channel;
    protected ListDisplay listbox;
    protected ChannelListData data;
    protected Capabilities capabilities;
    protected MouseAdapter mouseListener;
    protected ListBoxOptions watcher;
    protected LinkedList listeners = new LinkedList();

    public ListDisplay getListbox() {
        return this.listbox;
    }

    public void cleanup() {
        ((InternalDataList)this.capabilities.getDataStructure("clientInformation")).installChannelWatch(this.channel.getName(), null);
        this.watcher = null;
        this.listeners.clear();
        super.cleanup();
    }

    public ChannelWindow(Channel _channel) {
        this.channel = _channel;
    }

    public void init(ClientWindow _temp) {
        super.init(_temp);
        this.data = new ChannelListData(this.channel);
        this.listbox = new ListDisplay(this.data);
        this.watcher = new ListBoxOptions(this, this.listbox);
        this.mouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                ChannelWindow.this.maybeShowPopupNicklist(ev, "nicklist");
            }

            public void mouseReleased(MouseEvent ev) {
                ChannelWindow.this.maybeShowPopupNicklist(ev, "nicklist");
            }

            public void mouseClicked(MouseEvent ev) {
                if (ev.getClickCount() >= 2 && !ev.isPopupTrigger() && (ev.getButton() & 3) != 3) {
                    ChannelWindow.this.fireClickEvent(ev);
                } else {
                    ChannelWindow.this.maybeShowPopupNicklist(ev, "nicklist");
                }
            }
        };
        this.listbox.addMouseListener(this.mouseListener);
    }

    protected void maybeShowPopupNicklist(MouseEvent ev, String desc) {
        JPopupMenu menu = this.getPopupMenu(desc, null);
        if (ev.isPopupTrigger() && menu != null) {
            ListElement element = this.listbox.getSelectedElement();
            if (element != null) {
                HashMap<String, String> eventData = new HashMap<String, String>();
                User user = (User)element.getSource();
                eventData.put("$snick", user.getNick());
                Iterator i = this.listbox.getSelectedElements().iterator();
                StringBuffer values = new StringBuffer();
                while (i.hasNext()) {
                    User temp = (User)((ListElement)i.next()).getSource();
                    values.append(temp.getNick());
                    if (!i.hasNext()) continue;
                    values.append(" ");
                }
                eventData.put("$data", this.getName() + " " + values.toString());
                ScriptedPopupMenu.SetMenuData(eventData);
            }
            menu.show((JComponent)ev.getComponent(), ev.getX(), ev.getY());
            ev.consume();
        }
    }

    public void createChannel(Channel c) {
        this.channel = c;
        this.data.installCapabilities(this.capabilities);
        this.data.updateChannel(this.channel);
    }

    public void userAdded(User u) {
        this.listbox.repaint();
    }

    public void userRemoved(User u) {
        this.data.removeUser(u);
        this.listbox.repaint();
    }

    public void userChanged() {
        this.listbox.repaint();
    }

    public void touch() {
        super.touch();
        this.listbox.repaint();
    }

    public void installCapabilities(Capabilities c) {
        this.capabilities = c;
        super.installCapabilities(c);
        this.data.installCapabilities(c);
        ((InternalDataList)c.getDataStructure("clientInformation")).installChannelWatch(this.channel.getName(), this);
    }

    public ImageIcon getImageIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon(ClientState.getClientState().getResource("channel.gif"));
        }
        return this.icon;
    }

    public String getQuery() {
        return this.channel.getName();
    }

    public String getName() {
        return this.channel.getName();
    }

    public String getWindowType() {
        return "channel";
    }

    public void addClickListener(ClickListener l) {
        this.listeners.add(l);
    }

    public void fireClickEvent(MouseEvent mev) {
        String target = "";
        ListElement element = this.listbox.getSelectedElement();
        if (element != null) {
            User user = (User)element.getSource();
            target = user.getNick();
            ClickEvent ev = new ClickEvent(target, target, mev);
            ListIterator i = this.listeners.listIterator();
            while (i.hasNext() && !ev.isConsumed()) {
                ClickListener l = (ClickListener)i.next();
                l.wordClicked(ev);
            }
            if (!ev.isConsumed()) {
                this.capabilities.getUserInterface().openQueryWindow(target, true);
            }
        }
    }

    public int compareWindowType() {
        return 2;
    }
}

