/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import contrib.javapro.JSortTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rero.gui.SessionManager;
import rero.gui.toolkit.GeneralListModel;
import rero.gui.windows.GeneralListDialog;
import rero.ircfw.interfaces.ChatListener;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.util.ClientUtils;
import rero.util.StringUtils;
import rero.util.TokenizedString;
import text.AttributedString;

public class ChannelListDialog
extends GeneralListDialog
implements ActionListener {
    protected JTextField search;
    protected JLabel label;
    protected JSortTable table;

    public void actionPerformed(ActionEvent ev) {
        ((ChannelTableModel)this.model).search(this.search.getText());
    }

    public void init() {
        this.capabilities.addTemporaryListener((ChannelTableModel)this.model);
    }

    public void processMouseEvent(MouseEvent ev, int row) {
        ChannelTableModel temp = (ChannelTableModel)this.model;
        SessionManager.getGlobalCapabilities().getActiveSession().executeCommand("/JOIN " + ((LChannel)temp.getData().get(row)).getChannel());
    }

    public ChannelListDialog() {
        super("Channel List", "list", new ChannelTableModel());
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        top.setOpaque(true);
        JPanel righttop = new JPanel();
        righttop.setLayout(new FlowLayout(2));
        righttop.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.search = new JTextField();
        this.search.setColumns(12);
        this.search.addActionListener(this);
        JButton doit = new JButton("Search");
        doit.addActionListener(this);
        righttop.add(this.search);
        righttop.add(doit);
        top.add((Component)righttop, "East");
        this.label = new JLabel("Waiting for the storm...");
        ((ChannelTableModel)this.model).setLabel(this.label);
        top.add((Component)this.label, "Center");
        this.add((Component)top, "North");
    }

    public String getWindowType() {
        return "ListDialog";
    }

    private static class ChannelTableModel
    extends GeneralListModel
    implements ChatListener,
    FrameworkConstants {
        protected ArrayList filter = null;
        protected ArrayList channels = new ArrayList(10000);
        protected int x = 0;
        protected JLabel label;

        public HashMap getEventHashMap(int row) {
            LChannel channel = (LChannel)this.getData().get(row);
            return ClientUtils.getEventHashMap(channel.getChannel(), channel.getUsers() + " " + channel.getTopic());
        }

        public void setLabel(JLabel l) {
            this.label = l;
        }

        public boolean isChatEvent(String id, HashMap data) {
            return id.equals("321") || id.equals("322") || id.equals("323");
        }

        public void search(String criteria) {
            if (criteria.equals("")) {
                this.filter = null;
                this.fireTableDataChanged();
                return;
            }
            this.filter = new ArrayList();
            Iterator i = this.channels.iterator();
            while (i.hasNext()) {
                LChannel temp = (LChannel)i.next();
                if (!temp.matches(criteria)) continue;
                this.filter.add(temp);
            }
            this.fireTableDataChanged();
        }

        private ArrayList getData() {
            if (this.filter != null) {
                return this.filter;
            }
            return this.channels;
        }

        public int fireChatEvent(HashMap data) {
            String event = (String)data.get("$event");
            if (event.equals("321")) {
                this.label.setText("... Listing Channels ...");
                this.channels.clear();
                this.filter = null;
                this.fireTableDataChanged();
            }
            if (event.equals("322")) {
                TokenizedString text = new TokenizedString(data.get("$parms").toString());
                text.tokenize(" ");
                this.channels.add(new LChannel(text.getToken(0), Integer.parseInt(text.getToken(1)), text.getTokenFrom(2)));
                if (this.x % 1000 == 0) {
                    this.fireTableDataChanged();
                }
                if (this.x > 10000 && this.x < 11000) {
                    this.label.setText("Go grab a beer, this is gonna be awhile...");
                } else if (this.x > 20000 && this.x < 21000) {
                    this.label.setText("I bet we're not even halfway there yet");
                } else if (this.x > 25000 && this.x < 26000) {
                    this.label.setText("So what do you do for a living?");
                } else if (this.x > 26000 && this.x < 26500) {
                    this.label.setText("Really, does that make you gay?");
                } else if (this.x > 26500 && this.x < 27500) {
                    this.label.setText("Don't worry, I don't judge");
                } else if (this.x > 27500 && this.x < 28500) {
                    this.label.setText("I'm just an irc client... or am I?");
                } else if (this.x > 35000 && this.x < 36000) {
                    this.label.setText("I love you.  You love me.  We're a happy...");
                } else if (this.x > 36000 && this.x < 36500) {
                    this.label.setText("... family?");
                } else if (this.x > 43000 && this.x < 44000) {
                    this.label.setText("How many freaking channels are on this network?");
                } else if (this.x % 175 == 0) {
                    this.label.setText(".x. Listing Channels .x.: " + this.channels.size());
                } else if (this.x % 175 == 43) {
                    this.label.setText("..x Listing Channels ..x: " + this.channels.size());
                } else if (this.x % 175 == 81) {
                    this.label.setText(".x. Listing Channels .x.: " + this.channels.size());
                } else if (this.x % 175 == 127) {
                    this.label.setText("x.. Listing Channels x..: " + this.channels.size());
                }
                ++this.x;
            }
            if (event.equals("323")) {
                this.label.setText("Channel /list complete: " + this.channels.size() + " channels");
                this.x = 0;
                this.fireTableDataChanged();
                return 5;
            }
            return 2;
        }

        public void sortColumn(int col, boolean ascending) {
            Collections.sort(this.getData(), new ChannelComparator(col, ascending));
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.getData().size();
        }

        public int getColumnCount() {
            return 3;
        }

        public int getColumnWidth(int col) {
            if (col == 0) {
                return 150;
            }
            if (col == 1) {
                return 75;
            }
            return -1;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "#Channel";
                }
                case 1: {
                    return "Users";
                }
                case 2: {
                    return "Current Topic";
                }
            }
            return "Unknown";
        }

        public Object getValueAt(int row, int col) {
            if (row >= this.getData().size()) {
                return null;
            }
            switch (col) {
                case 0: {
                    return ((LChannel)this.getData().get(row)).getChannelAttributed();
                }
                case 1: {
                    return ((LChannel)this.getData().get(row)).getUsersAttributed();
                }
                case 2: {
                    return ((LChannel)this.getData().get(row)).getTopicAttributed();
                }
            }
            return "Unknown";
        }
    }

    private static class ChannelComparator
    implements Comparator {
        private int criteria;
        private boolean reverse;

        public ChannelComparator(int _criteria, boolean _reverse) {
            this.criteria = _criteria;
            this.reverse = _reverse;
        }

        public int compare(Object one, Object two) {
            LChannel a = (LChannel)one;
            LChannel b = (LChannel)two;
            if (this.reverse) {
                LChannel c = b;
                b = a;
                a = c;
            }
            switch (this.criteria) {
                case 0: {
                    return a.getChannel().compareTo(b.getChannel());
                }
                case 1: {
                    if (a.getUsers() < b.getUsers()) {
                        return 1;
                    }
                    if (a.getUsers() > b.getUsers()) {
                        return -1;
                    }
                    return 0;
                }
                case 2: {
                    return a.getTopic().compareTo(b.getTopic());
                }
            }
            return 0;
        }
    }

    private static class LChannel {
        private String name;
        private String topic;
        private int users;
        private AttributedString topicattrs;
        private AttributedString nameattrs;
        private AttributedString userattrs;

        public LChannel(String _name, int _users, String _topic) {
            this.name = _name;
            this.users = _users;
            this.topic = _topic;
            if (this.topic.equals(":")) {
                this.topic = "";
            }
        }

        public String getChannel() {
            return this.name;
        }

        public String getTopic() {
            return this.topic;
        }

        public AttributedString getTopicAttributed() {
            if (this.topicattrs != null) {
                return this.topicattrs;
            }
            this.topicattrs = AttributedString.CreateAttributedString(this.topic);
            this.topicattrs.assignWidths();
            return this.topicattrs;
        }

        public AttributedString getChannelAttributed() {
            if (this.nameattrs != null) {
                return this.nameattrs;
            }
            this.nameattrs = AttributedString.CreateAttributedString(this.name);
            this.nameattrs.assignWidths();
            return this.nameattrs;
        }

        public AttributedString getUsersAttributed() {
            if (this.userattrs != null) {
                return this.userattrs;
            }
            this.userattrs = AttributedString.CreateAttributedString(this.users + "");
            this.userattrs.assignWidths();
            return this.userattrs;
        }

        public int getUsers() {
            return this.users;
        }

        public boolean matches(String criteria) {
            if (criteria.indexOf(42) > -1 || criteria.indexOf(63) > -1) {
                return StringUtils.iswm(criteria.toUpperCase(), (this.getChannel() + " " + StringUtils.strip(this.getTopic())).toUpperCase());
            }
            return (this.getChannel() + " " + StringUtils.strip(this.getTopic())).toUpperCase().indexOf(criteria.toUpperCase()) > -1;
        }
    }
}

