/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.windows;

import java.util.HashMap;
import java.util.Iterator;
import rero.client.Capabilities;
import rero.ircfw.Channel;
import rero.ircfw.User;
import text.AttributedString;
import text.AttributedText;
import text.list.ListData;
import text.list.ListElement;

public class ChannelListData
extends ListData {
    protected HashMap userInfo;
    protected Channel channel;
    protected Capabilities capabilities;
    protected HashMap event;
    protected Iterator tempIter;
    protected int iterValue;

    public void dirty() {
        this.userInfo.clear();
    }

    public void removeUser(User u) {
        this.userInfo.remove(u);
    }

    public void installCapabilities(Capabilities c) {
        this.capabilities = c;
    }

    public void updateChannel(Channel _channel) {
        this.channel = _channel;
        this.event = new HashMap();
        this.event.put("$channel", this.channel.getName());
        this.userInfo = new HashMap();
    }

    public ChannelListData(Channel _channel) {
        this.updateChannel(_channel);
    }

    public int getSize() {
        if (this.getChannel() == null) {
            return 0;
        }
        return this.getChannel().getAllUsers().size();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ListElement head() {
        if (this.getChannel() == null) {
            return null;
        }
        this.iterValue = this.getValue();
        this.tempIter = this.getChannel().getAllUsers().iterator();
        for (int x = 0; x < this.iterValue; ++x) {
            this.tempIter.next();
        }
        return this.next();
    }

    public ListElement next() {
        if (this.getChannel() != null && this.tempIter.hasNext()) {
            return this.getElementForUser((User)this.tempIter.next());
        }
        return null;
    }

    public Object getSynchronizationKeyOuter() {
        if (this.capabilities != null) {
            return this.capabilities.getDataStructure("scriptVariables");
        }
        return this.getChannel().getAllUsers();
    }

    public Object getSynchronizationKeyInner() {
        return this.getChannel().getAllUsers();
    }

    protected ListElement getElementForUser(User u) {
        UserElement temp = (UserElement)this.userInfo.get(u);
        if (temp == null) {
            temp = new UserElement(u);
            this.userInfo.put(u, temp);
        }
        temp.touch();
        return temp;
    }

    public ListElement getElementAt(int number) {
        if (this.getChannel() == null) {
            return null;
        }
        Iterator i = this.getChannel().getAllUsers().iterator();
        for (int x = 0; x < number && i.hasNext(); ++x) {
            i.next();
        }
        if (i.hasNext()) {
            User t = (User)i.next();
            return this.getElementForUser(t);
        }
        return null;
    }

    public Iterator dataIterator() {
        return new MyIterator();
    }

    private class UserElement
    extends ListElement {
        protected int oldState;
        protected User user;
        protected AttributedString idle = null;
        protected AttributedString normal = null;
        protected int oldNick;

        public UserElement(User _user) {
            this.user = _user;
            this.oldState = _user.getModeFor(ChannelListData.this.getChannel());
            this.oldNick = _user.getNick().hashCode();
            this.setSource(this.user);
        }

        public void touch() {
            if (this.oldState != this.user.getModeFor(ChannelListData.this.getChannel()) || this.oldNick != this.user.getNick().hashCode()) {
                this.idle = null;
                this.normal = null;
                this.oldNick = this.user.getNick().hashCode();
                this.oldState = this.user.getModeFor(ChannelListData.this.getChannel());
                this.setSelected(false);
            }
        }

        protected AttributedString buildString(String prepend) {
            if (ChannelListData.this.capabilities != null) {
                ChannelListData.this.event.put("$nick", this.user.getNick());
                AttributedString temp = AttributedString.CreateAttributedString(prepend + ChannelListData.this.capabilities.getOutputCapabilities().parseSet(ChannelListData.this.event, "NICKLIST_FORMAT"));
                temp.assignWidths();
                return temp;
            }
            return null;
        }

        protected AttributedString getData() {
            if (this.user.getIdleTime() > 300) {
                if (this.idle == null) {
                    this.idle = this.buildString("\u0016");
                }
                return this.idle;
            }
            if (this.normal == null) {
                this.normal = this.buildString("");
            }
            return this.normal;
        }

        public AttributedText getAttributedText() {
            AttributedString data = this.getData();
            if (data != null) {
                return this.getData().getAttributedText();
            }
            AttributedString temp = AttributedString.CreateAttributedString("");
            temp.assignWidths();
            return temp.getAttributedText();
        }

        public String getText() {
            return this.getData().getText();
        }
    }

    private class MyIterator
    implements Iterator {
        protected Iterator i;

        public MyIterator() {
            this.i = ChannelListData.this.getChannel().getAllUsers().iterator();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return ChannelListData.this.getElementForUser((User)this.i.next());
        }

        public void remove() {
        }
    }
}

