/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.toolkit;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JToolBar;
import rero.config.ClientState;
import rero.config.ClientStateListener;

public class OrientedToolBar
extends JToolBar
implements ClientStateListener {
    public static final int BUTTON_FIXED_WIDTH = 95;
    private FlowLayout2 fixed = null;
    private GridLayout2 fill = null;

    public OrientedToolBar() {
        this.setFloatable(false);
        this.propertyChanged(null, null);
        ClientState.getClientState().addClientStateListener("switchbar.fixed", this);
    }

    public void propertyChanged(String var, String var2) {
        int orientation = ClientState.getClientState().getInteger("switchbar.position", 0);
        if (orientation == 2 || orientation == 3) {
            this.setLayout(new GridLayout3());
            this.validate();
        } else if (ClientState.getClientState().isOption("switchbar.fixed", false)) {
            if (this.fixed == null || this.fill == null) {
                this.fixed = new FlowLayout2(0, 0, 0);
                this.fill = new GridLayout2();
            }
            this.setLayout(this.fixed);
            this.validate();
        } else {
            this.setLayout(new GridLayout());
            this.validate();
        }
    }

    public void setOrientation(int o) {
        this.propertyChanged(null, null);
    }

    private class GridLayout3
    extends GridLayout {
        private GridLayout3() {
        }

        public int getColumns() {
            return 1;
        }

        public void layoutContainer(Container c) {
            if (c.getComponentCount() > 0) {
                int buttonheight = OrientedToolBar.this.getComponent((int)0).getPreferredSize().height + this.getVgap();
                if (buttonheight * c.getComponentCount() > c.getHeight()) {
                    this.setRows(c.getComponentCount());
                    this.setColumns(1);
                } else {
                    this.setRows(c.getHeight() / buttonheight);
                    this.setColumns(1);
                }
            }
            super.layoutContainer(c);
        }
    }

    private class GridLayout2
    extends GridLayout {
        private GridLayout2() {
        }

        public void layoutContainer(Container c) {
            if (c.getComponentCount() * 97 < c.getWidth()) {
                c.setLayout(OrientedToolBar.this.fixed);
                c.validate();
            } else {
                super.layoutContainer(c);
            }
        }
    }

    private class FlowLayout2
    extends FlowLayout {
        public FlowLayout2(int dir, int vgap, int hgap) {
            super(dir, vgap, hgap);
        }

        public void layoutContainer(Container c) {
            if (c.getComponentCount() * 97 < c.getWidth()) {
                super.layoutContainer(c);
            } else {
                c.setLayout(OrientedToolBar.this.fill);
                c.validate();
            }
        }
    }
}

