/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.sdi;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.KeyBindings;
import rero.gui.sdi.ClientSingleWindow;
import rero.gui.toolkit.OrientedToolBar;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.StatusWindow;
import rero.gui.windows.SwitchBarOptions;
import rero.gui.windows.WindowManager;

public class ClientPanel
extends WindowManager
implements ActionListener,
ClientStateListener {
    protected StatusWindow active = null;
    protected JPanel desktop;
    protected JPanel top;
    protected JLabel button;

    public void propertyChanged(String key, String value) {
        if (key.equals("switchbar.position")) {
            int orientation = ClientState.getClientState().getInteger("switchbar.position", 0);
            this.top.remove(this.button);
            if (orientation == 2 || orientation == 3) {
                this.top.add((Component)this.button, "South");
            } else {
                this.top.add((Component)this.button, "East");
            }
        } else {
            super.propertyChanged(key, value);
        }
    }

    public void init() {
        this.switchbar = new OrientedToolBar();
        this.top = new JPanel();
        this.top.setLayout(new BorderLayout(5, 0));
        this.button = new JLabel("<html><b>X</b></html>", 0);
        this.button.setToolTipText("Close active window");
        this.button.addMouseListener(new MouseAdapter(){
            protected Color original;

            public void mousePressed(MouseEvent e) {
                this.original = ClientPanel.this.button.getForeground();
                ClientPanel.this.button.setForeground(UIManager.getColor("TextArea.selectionBackground"));
            }

            public void mouseClicked(MouseEvent e) {
                ClientPanel.this.processClose();
            }

            public void mouseReleased(MouseEvent e) {
                ClientPanel.this.button.setForeground(this.original);
            }

            public void mouseEntered(MouseEvent e) {
                ClientPanel.this.button.setText("<html><b><u>X</u></b></html>");
            }

            public void mouseExited(MouseEvent e) {
                ClientPanel.this.button.setText("<html><b>X</b></html>");
            }
        });
        this.top.add((Component)this.switchbar, "Center");
        this.propertyChanged("switchbar.position", null);
        this.setLayout(new BorderLayout());
        this.switchOptions = new SwitchBarOptions(this, this.top);
        this.windowMap = new HashMap();
        this.windows = new LinkedList();
        this.desktop = new JPanel();
        this.desktop.setLayout(new BorderLayout());
        this.add((Component)this.desktop, "Center");
        new MantainActiveFocus(this);
        ClientState.getClientState().addClientStateListener("switchbar.position", this);
    }

    public void addWindow(StatusWindow window, boolean selected) {
        ClientSingleWindow temp = new ClientSingleWindow(this);
        window.init(temp);
        this.windowMap.put(window.getWindow(), window);
        this.windowMap.put(window.getButton(), window);
        window.getButton().addActionListener(this);
        this.addToSwitchbar(window);
        if (selected) {
            if (this.active != null) {
                this.doDeactivate(this.active);
            }
            this.desktop.add((Component)temp, "Center");
            this.active = window;
        }
        temp.processOpen();
        if (selected && !window.getButton().isSelected()) {
            window.getButton().setSelected(true);
        }
        this.revalidate();
        this.refreshFocus();
    }

    public void killWindow(ClientWindow cwindow) {
        StatusWindow window = this.getWindowFor(cwindow);
        if (window == null) {
            return;
        }
        ((ClientSingleWindow)window.getWindow()).processClose();
        int idx = this.windows.indexOf(window);
        this.switchbar.remove(window.getButton());
        this.windowMap.remove(window.getButton());
        this.windowMap.remove(window.getWindow());
        this.windows.remove(window);
        this.desktop.remove(window);
        if (window == this.active && this.active.getName().equals("%STATUS%")) {
            this.active = null;
        } else if (window == this.active) {
            this.newActive(idx, true);
            this.refreshFocus();
        }
        this.switchbar.validate();
        this.switchbar.repaint();
    }

    public void processClose() {
        if (this.active != null) {
            this.killWindow(this.active.getWindow());
        }
    }

    public StatusWindow getActiveWindow() {
        return this.active;
    }

    protected void doActivate(StatusWindow window) {
        if (this.active != null && this.active != window.getWindow()) {
            this.doDeactivate(this.active);
        }
        this.desktop.add((Component)((ClientSingleWindow)window.getWindow()), "Center");
        this.active = window;
        ((ClientSingleWindow)this.active.getWindow()).processActive();
        if (!window.getButton().isSelected()) {
            window.getButton().setSelected(true);
        }
        this.revalidate();
        this.repaint();
        this.refreshFocus();
    }

    public void refreshFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ClientPanel.this.getActiveWindow() != null && ClientPanel.this.isShowing() && ClientPanel.this.getActiveWindow().isLegalWindow() && !KeyBindings.is_dialog_active) {
                    ClientPanel.this.getActiveWindow().getInput().requestFocus();
                }
            }
        });
    }

    protected void doDeactivate(StatusWindow window) {
        this.desktop.remove((ClientSingleWindow)window.getWindow());
        ((ClientSingleWindow)window.getWindow()).processInactive();
        window.getButton().setSelected(false);
    }

    private class MantainActiveFocus
    extends ComponentAdapter {
        public MantainActiveFocus(JComponent component) {
            component.addComponentListener(this);
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
            ClientPanel.this.refreshFocus();
        }
    }
}

