/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.script;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import rero.gui.IRCSession;
import rero.gui.SessionManager;
import rero.gui.windows.ChannelWindow;
import rero.ircfw.User;
import rero.util.ClientUtils;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;
import text.list.ListElement;

public class WindowOperators
implements Predicate,
Function,
Loadable {
    protected IRCSession session;

    public WindowOperators(IRCSession _session) {
        this.session = _session;
    }

    public void scriptLoaded(ScriptInstance script) {
        String[] contents = new String[]{"&setWindowPrompt", "&getWindowPrompt", "&setWindowTitle", "&getWindowTitle", "&renameWindow", "&getSelectedText", "&cutSelectedText", "&copySelectedText", "&pasteText", "&replaceSelectedText", "&setInputText", "&getInputText", "&getSelectedUsers", "&getSelectedUser", "&getClipboardText", "&setClipboardText", "&scrollWindow", "-iswindow", "-isspecial", "&refreshWindow"};
        for (int x = 0; x < contents.length; ++x) {
            script.getScriptEnvironment().getEnvironment().put(contents[x], this);
        }
        script.getScriptEnvironment().getEnvironment().put("&getCursorPosition", new getCursorPosition());
        script.getScriptEnvironment().getEnvironment().put("&setCursorPosition", new setCursorPosition());
        script.getScriptEnvironment().getEnvironment().put("&setButtonColor", new setButtonColor());
        script.getScriptEnvironment().getEnvironment().put("&getButtonColor", new getButtonColor());
    }

    public void scriptUnloaded(ScriptInstance script) {
    }

    public Scalar evaluate(final String function2, final ScriptInstance script, Stack locals) {
        if (function2.equals("&getSelectedText")) {
            return SleepUtils.getScalar(this.session.getActiveWindow().getInput().getSelectedText());
        }
        if (function2.equals("&renameWindow") && locals.size() == 2) {
            String a = locals.pop().toString();
            String b = locals.pop().toString();
            this.session.renameWindow(a, b);
            return SleepUtils.getEmptyScalar();
        }
        if (function2.equals("&scrollWindow") && locals.size() == 2) {
            String a = locals.pop().toString();
            int b = BridgeUtilities.getInt(locals, 0);
            if (this.session.getWindow(a) != null && this.session.getWindow(a).isLegalWindow()) {
                this.session.getWindow(a).getDisplay().scroll(b);
            }
        } else {
            if (function2.equals("&getWindowTitle") && locals.size() == 1) {
                String window = locals.pop().toString();
                if (this.session.getWindow(window) != null) {
                    return SleepUtils.getScalar(this.session.getWindow(window).getTitle());
                }
                return SleepUtils.getEmptyScalar();
            }
            if (function2.equals("&getWindowTitle") && locals.size() == 0) {
                return SleepUtils.getScalar(SessionManager.getGlobalCapabilities().getFrame().getTitle());
            }
            if (function2.equals("&getWindowPrompt") && locals.size() == 1) {
                String window = locals.pop().toString();
                if (this.session.getWindow(window) != null) {
                    return SleepUtils.getScalar(this.session.getWindow(window).getInput().getIndent());
                }
                return SleepUtils.getEmptyScalar();
            }
            if (function2.equals("&getInputText") && locals.size() == 1) {
                String window = locals.pop().toString();
                if (this.session.getWindow(window) != null) {
                    return SleepUtils.getScalar(this.session.getWindow(window).getInput().getText());
                }
            } else {
                if (function2.equals("&getSelectedUser") && locals.size() == 1) {
                    ListElement element;
                    String window = locals.pop().toString();
                    if (this.session.getWindow(window) != null && (element = ((ChannelWindow)this.session.getWindow(window)).getListbox().getSelectedElement()) != null) {
                        User user = (User)element.getSource();
                        return SleepUtils.getScalar(user.getNick());
                    }
                    return SleepUtils.getEmptyScalar();
                }
                if (function2.equals("&getSelectedUsers") && locals.size() == 1) {
                    String window = locals.pop().toString();
                    if (this.session.getWindow(window) != null && this.session.getWindow(window) instanceof ChannelWindow) {
                        HashSet<String> returnValue = new HashSet<String>();
                        Iterator list = ((ChannelWindow)this.session.getWindow(window)).getListbox().getSelectedElements().iterator();
                        while (list.hasNext()) {
                            ListElement element = (ListElement)list.next();
                            User user = (User)element.getSource();
                            returnValue.add(user.getNick());
                        }
                        return SleepUtils.getArrayWrapper(returnValue);
                    }
                    return SleepUtils.getEmptyScalar();
                }
                if (function2.equals("&getClipboardText")) {
                    Clipboard cb = null;
                    if (Toolkit.getDefaultToolkit().getSystemSelection() != null) {
                        cb = Toolkit.getDefaultToolkit().getSystemSelection();
                    } else if (Toolkit.getDefaultToolkit().getSystemClipboard() != null) {
                        cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    }
                    try {
                        if (cb != null) {
                            return SleepUtils.getScalar(cb.getContents(this).getTransferData(DataFlavor.stringFlavor).toString());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return SleepUtils.getEmptyScalar();
                }
                if (function2.equals("&setClipboardText")) {
                    String sel = BridgeUtilities.getString(locals, "");
                    StringSelection selected = new StringSelection(sel);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selected, selected);
                    if (Toolkit.getDefaultToolkit().getSystemSelection() != null) {
                        Toolkit.getDefaultToolkit().getSystemSelection().setContents(selected, selected);
                    }
                } else {
                    final Stack<String> tempLocals = new Stack<String>();
                    while (!locals.isEmpty()) {
                        tempLocals.push(locals.pop().toString());
                    }
                    ClientUtils.invokeLater(new Runnable(){

                        public void run() {
                            WindowOperators.this.safeEvaluate(function2, script, tempLocals);
                        }
                    });
                }
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    public void safeEvaluate(String function2, ScriptInstance script, Stack locals) {
        String text = "";
        String window = "";
        if (locals.size() == 1) {
            text = locals.pop().toString();
        } else if (locals.size() == 2) {
            text = locals.pop().toString();
            window = locals.pop().toString();
        }
        if (function2.equals("&cutSelectedText")) {
            this.session.getActiveWindow().getInput().cut();
        } else if (function2.equals("&copySelectedText")) {
            this.session.getActiveWindow().getInput().copy();
        } else if (function2.equals("&pasteText")) {
            this.session.getActiveWindow().getInput().paste();
        } else if (function2.equals("&replaceSelectedText")) {
            this.session.getActiveWindow().getInput().replaceSelection(text);
        } else if (function2.equals("&setWindowTitle")) {
            if (window.length() > 0 && this.session.getWindow(window) != null) {
                this.session.getWindow(window).setTitle(text);
            } else {
                SessionManager.getGlobalCapabilities().getFrame().setTitle(text);
            }
        } else if (function2.equals("&setWindowPrompt")) {
            if (this.session.getWindow(window) != null) {
                this.session.getWindow(window).getInput().setIndent(text);
            }
        } else if (function2.equals("&refreshWindow")) {
            if (this.session.getWindow(text) != null) {
                this.session.getWindow(text).touch();
            }
        } else if (function2.equals("&setInputText") && this.session.getWindow(window) != null) {
            this.session.getWindow(window).getInput().setText(text);
        }
    }

    public boolean decide(String predicate, ScriptInstance script, Stack terms) {
        if (terms.size() != 1) {
            return false;
        }
        String channel = ((Object)((Scalar)terms.pop()).getValue()).toString();
        if (predicate.equals("-iswindow")) {
            return this.session.isWindow(channel);
        }
        if (predicate.equals("-isspecial")) {
            return !this.session.getWindow(channel).isLegalWindow();
        }
        return false;
    }

    private class setCursorPosition
    implements Function {
        private setCursorPosition() {
        }

        public Scalar evaluate(String function2, ScriptInstance script, Stack locals) {
            String window = BridgeUtilities.getString(locals, "");
            if (WindowOperators.this.session.getWindow(window) != null && WindowOperators.this.session.getWindow(window).isLegalWindow()) {
                WindowOperators.this.session.getWindow(window).getInput().setCaretPosition(BridgeUtilities.getInt(locals, 0));
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getCursorPosition
    implements Function {
        private getCursorPosition() {
        }

        public Scalar evaluate(String function2, ScriptInstance script, Stack locals) {
            String window = BridgeUtilities.getString(locals, "");
            if (WindowOperators.this.session.getWindow(window) != null && WindowOperators.this.session.getWindow(window).isLegalWindow()) {
                return SleepUtils.getScalar(WindowOperators.this.session.getWindow(window).getInput().getCaretPosition());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class setButtonColor
    implements Function {
        private setButtonColor() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            String window = BridgeUtilities.getString(locals, "");
            if (WindowOperators.this.session.getWindow(window) != null) {
                WindowOperators.this.session.getWindow(window).getButton().setForeground(Color.decode(locals.pop().toString()));
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getButtonColor
    implements Function {
        private getButtonColor() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            String window = BridgeUtilities.getString(locals, "");
            if (WindowOperators.this.session.getWindow(window) != null) {
                return SleepUtils.getScalar(WindowOperators.this.session.getWindow(window).getButton().getForeground().getRGB());
            }
            return SleepUtils.getEmptyScalar();
        }
    }
}

