/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.script;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;
import javax.swing.JFrame;
import rero.gui.IRCSession;
import rero.gui.SessionManager;
import rero.gui.mdi.ClientDesktop;
import rero.gui.windows.StatusWindow;
import rero.ircfw.InternalDataList;
import rero.util.ClientUtils;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class WindowManagementOperators
implements Function,
Loadable {
    protected IRCSession session;

    public WindowManagementOperators(IRCSession _session) {
        this.session = _session;
    }

    public void scriptLoaded(ScriptInstance script) {
        String[] contents = new String[]{"&openWindow", "&closeWindow", "&setWindowState", "&getWindowState", "&activateWindow", "&getActiveWindow", "&getCurrentWindow", "&getWindows", "&tileWindows", "&cascadeWindows"};
        for (int x = 0; x < contents.length; ++x) {
            script.getScriptEnvironment().getEnvironment().put(contents[x], this);
        }
    }

    public void scriptUnloaded(ScriptInstance script) {
    }

    public Scalar evaluate(String function2, ScriptInstance script, Stack locals) {
        if (function2.equals("&openWindow")) {
            String parms = locals.pop().toString();
            InternalDataList ircData = (InternalDataList)this.session.getCapabilities().getDataStructure("clientInformation");
            if (ClientUtils.isChannel(parms)) {
                this.session.getCapabilities().getUserInterface().openChannelWindow(ircData.getChannel(parms));
            } else {
                this.session.getCapabilities().getUserInterface().openQueryWindow(parms, locals.isEmpty());
            }
        } else if (function2.equals("&closeWindow")) {
            String window = locals.pop().toString();
            if (this.session.isWindow(window)) {
                this.session.getWindow(window).getWindow().closeWindow();
            }
        } else if (function2.equals("&setWindowState") && locals.size() == 2) {
            String window = locals.pop().toString();
            String state = locals.pop().toString().toUpperCase();
            if (this.session.isWindow(window)) {
                if (state.equals("NORMAL")) {
                    this.session.getWindow(window).getWindow().setMaximum(false);
                    this.session.getWindow(window).getWindow().setIcon(false);
                } else if (state.equals("MAXIMIZED")) {
                    this.session.getWindow(window).getWindow().setIcon(false);
                    this.session.getWindow(window).getWindow().setMaximum(true);
                } else if (state.equals("MINIMIZED")) {
                    this.session.getWindow(window).getWindow().setIcon(true);
                }
            }
        } else if (function2.equals("&setWindowState") && locals.size() == 1) {
            String state = locals.pop().toString().toUpperCase();
            JFrame window = SessionManager.getGlobalCapabilities().getFrame();
            if (state.equals("NORMAL")) {
                window.setExtendedState(0);
            } else if (state.equals("MAXIMIZED")) {
                window.setExtendedState(6);
            } else if (state.equals("MINIMIZED")) {
                window.setExtendedState(1);
            }
        } else {
            if (function2.equals("&getWindowState") && locals.size() == 0) {
                JFrame window = SessionManager.getGlobalCapabilities().getFrame();
                int state = window.getExtendedState();
                if ((state & 1) == 1) {
                    return SleepUtils.getScalar("MINIMIZED");
                }
                if ((state & 6) == 6) {
                    return SleepUtils.getScalar("MAXIMIZED");
                }
                return SleepUtils.getScalar("NORMAL");
            }
            if (function2.equals("&getWindowState") && locals.size() == 1) {
                String window = locals.pop().toString();
                if (this.session.isWindow(window)) {
                    if (this.session.getWindow(window).getWindow().isMaximum()) {
                        return SleepUtils.getScalar("MAXIMIZED");
                    }
                    if (this.session.getWindow(window).getWindow().isIcon()) {
                        return SleepUtils.getScalar("MINIMIZED");
                    }
                    return SleepUtils.getScalar("NORMAL");
                }
            } else {
                if (function2.equals("&getActiveWindow")) {
                    if (this.session.getRealActiveWindow() == null) {
                        return SleepUtils.getScalar("%STATUS%");
                    }
                    return SleepUtils.getScalar(this.session.getRealActiveWindow().getName());
                }
                if (function2.equals("&getCurrentWindow")) {
                    return SleepUtils.getScalar(this.session.getActiveWindow().getName());
                }
                if (function2.equals("&getWindows")) {
                    LinkedHashSet<String> returnValue = new LinkedHashSet<String>();
                    Iterator i = this.session.getAllWindows().iterator();
                    while (i.hasNext()) {
                        StatusWindow temp = (StatusWindow)i.next();
                        returnValue.add(temp.getName());
                    }
                    return SleepUtils.getArrayWrapper(returnValue);
                }
                if (function2.equals("&activateWindow") && locals.size() == 1) {
                    String window = locals.pop().toString();
                    if (this.session.isWindow(window)) {
                        this.session.getWindow(window).getWindow().activate();
                    }
                } else if (function2.equals("&tileWindows")) {
                    if (this.session.getDesktop() instanceof ClientDesktop) {
                        ClientUtils.invokeLater(new Runnable(){

                            public void run() {
                                ((ClientDesktop)WindowManagementOperators.this.session.getDesktop()).tileWindows();
                            }
                        });
                    }
                } else if (function2.equals("&cascadeWindows") && this.session.getDesktop() instanceof ClientDesktop) {
                    ClientUtils.invokeLater(new Runnable(){

                        public void run() {
                            ((ClientDesktop)WindowManagementOperators.this.session.getDesktop()).cascadeWindows();
                        }
                    });
                }
            }
        }
        return SleepUtils.getEmptyScalar();
    }
}

