/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.script;

import rero.bridges.event.EventBridge;
import rero.gui.IRCSession;
import rero.gui.script.SessionOperators;
import rero.gui.script.UIOperators;
import rero.gui.script.WindowAreaClickListener;
import rero.gui.script.WindowClickListener;
import rero.gui.script.WindowDataListener;
import rero.gui.script.WindowInputListener;
import rero.gui.script.WindowManagementOperators;
import rero.gui.script.WindowOperators;
import rero.gui.script.WindowStateListener;
import rero.gui.windows.ChannelWindow;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.EmptyWindow;
import rero.gui.windows.StatusWindow;

public class UIScriptBridge {
    protected IRCSession session;
    protected WindowStateListener windowState;
    protected WindowDataListener windowData;
    protected WindowClickListener windowClick;
    protected WindowClickListener windowDoubleClick;
    protected WindowClickListener windowSpecialClick;
    protected WindowInputListener windowInput;
    protected WindowAreaClickListener areaClickListener;
    protected SessionOperators sessionOps;
    protected WindowOperators windowOps;
    protected WindowManagementOperators windowMgmt;
    protected UIOperators interfaceOps;

    public UIScriptBridge(IRCSession _session) {
        this.session = _session;
        EventBridge bridge = (EventBridge)this.session.getCapabilities().getDataStructure("eventBridge");
        this.windowState = new WindowStateListener(this.session);
        this.windowState.registerListener(bridge);
        this.windowData = new WindowDataListener(this.session.getCapabilities().getUserInterface());
        bridge.registerEvent("window", this.windowData);
        this.windowClick = new WindowClickListener();
        bridge.registerEvent("click", this.windowClick);
        this.windowDoubleClick = new WindowClickListener();
        bridge.registerEvent("dclick", this.windowDoubleClick);
        this.areaClickListener = new WindowAreaClickListener();
        bridge.registerEvent("cclick", this.areaClickListener);
        this.windowSpecialClick = new WindowClickListener();
        bridge.registerEvent("sclick", this.windowSpecialClick);
        this.windowInput = new WindowInputListener();
        bridge.registerEvent("input", this.windowInput);
        this.windowOps = new WindowOperators(this.session);
        this.session.getCapabilities().getScriptCore().addBridge(this.windowOps);
        this.windowMgmt = new WindowManagementOperators(this.session);
        this.session.getCapabilities().getScriptCore().addBridge(this.windowMgmt);
        this.sessionOps = new SessionOperators(this.session);
        this.session.getCapabilities().getScriptCore().addBridge(this.sessionOps);
        this.interfaceOps = new UIOperators(this.session);
        this.session.getCapabilities().getScriptCore().addBridge(this.interfaceOps);
    }

    public void windowCreated(StatusWindow window) {
        window.getWindow().addWindowListener(this.windowState);
        if (window.isLegalWindow()) {
            window.getDisplay().addClickListener(this.windowClick);
            window.getDisplay().addClickListener(this.areaClickListener);
            window.getInput().addInputListener(this.windowInput);
            if (window instanceof ChannelWindow) {
                ((ChannelWindow)window).addClickListener(this.windowDoubleClick);
            }
        } else {
            ((EmptyWindow)window).addClickListener(this.windowSpecialClick);
        }
        this.windowState.onOpen(new ClientWindowEvent(window.getWindow()));
    }
}

