/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.script;

import java.util.LinkedList;
import java.util.Stack;
import rero.config.ClientState;
import rero.gui.IRCSession;
import rero.gui.windows.ScriptedListDialog;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class UIOperators
implements Function,
Loadable {
    protected IRCSession session;

    public UIOperators(IRCSession _session) {
        this.session = _session;
    }

    public void scriptLoaded(ScriptInstance script) {
        String[] contents = new String[]{"&refreshMenubar", "&showOptionDialog", "&showHelpDialog", "&showAboutDialog", "&showSearchDialog"};
        for (int x = 0; x < contents.length; ++x) {
            script.getScriptEnvironment().getEnvironment().put(contents[x], this);
        }
        script.getScriptEnvironment().getEnvironment().put("&showSortedList", new openSortedWindow());
        script.getScriptEnvironment().getEnvironment().put("&refreshData", new refreshData());
    }

    private static LinkedList extractData(Stack locals) {
        LinkedList<String> data = new LinkedList<String>();
        while (!locals.isEmpty()) {
            data.add(locals.pop().toString());
        }
        return data;
    }

    public void scriptUnloaded(ScriptInstance script) {
    }

    public Scalar evaluate(String function2, ScriptInstance script, Stack locals) {
        if (function2.equals("&refreshMenubar")) {
            ClientState.getClientState().fireChange("loaded.scripts", null);
        } else if (function2.equals("&showOptionDialog")) {
            this.session.getCapabilities().getGlobalCapabilities().showOptionDialog(BridgeUtilities.getString(locals, ""));
        } else if (function2.equals("&showHelpDialog")) {
            this.session.getCapabilities().getGlobalCapabilities().showHelpDialog(BridgeUtilities.getString(locals, ""));
        } else if (function2.equals("&showAboutDialog")) {
            this.session.getCapabilities().getGlobalCapabilities().showAboutDialog();
        } else if (function2.equals("&showSearchDialog")) {
            this.session.getCapabilities().getUserInterface().showSearchDialog(BridgeUtilities.getString(locals, "%STATUS%"));
        }
        return SleepUtils.getEmptyScalar();
    }

    private static class refreshData
    implements Function {
        private refreshData() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack locals) {
            ScriptedListDialog dialog = (ScriptedListDialog)BridgeUtilities.getObject(locals);
            dialog.refreshData();
            return SleepUtils.getEmptyScalar();
        }
    }

    private class openSortedWindow
    implements Function {
        private openSortedWindow() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack locals) {
            if (locals.size() < 3) {
                return SleepUtils.getEmptyScalar();
            }
            String title = locals.pop().toString();
            String hook = locals.pop().toString();
            Object data = locals.pop();
            return SleepUtils.getScalar(UIOperators.this.session.createSortedWindow(title, hook, data, UIOperators.extractData(locals)));
        }
    }
}

