/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.script;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Stack;
import rero.client.Capabilities;
import rero.gui.BuiltInLogger;
import rero.gui.GlobalCapabilities;
import rero.gui.IRCSession;
import rero.gui.SessionManager;
import rero.util.ClientUtils;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class SessionOperators
implements Loadable {
    protected IRCSession session;

    public SessionOperators(IRCSession _session) {
        this.session = _session;
    }

    private Capabilities getCapabilities() {
        return this.session.getCapabilities();
    }

    public void scriptLoaded(ScriptInstance script) {
        Hashtable env = script.getScriptEnvironment().getEnvironment();
        SessionUI manipulate = new SessionUI();
        env.put("&getSessionId", new getSessionId());
        env.put("&getActiveSessionId", new getActiveSessionId());
        env.put("&activateSession", manipulate);
        env.put("&getTotalSessions", new getTotalSessions());
        env.put("&setSessionColor", manipulate);
        env.put("&getSessionColor", new getSessionColor());
        env.put("&getSessionText", new getSessionText());
        env.put("&setSessionText", manipulate);
        env.put("&callInSession", new callCommandInSession());
        env.put("&getServerHost", new getServerName());
        env.put("&getServerPort", new getServerPort());
        env.put("&getServerNetwork", new getServerNetwork());
        env.put("&getServerPassword", new getServerPassword());
        env.put("&isServerConnected", new isServerConnected());
        env.put("&isServerSecure", new isServerSecure());
        env.put("&getLogFile", new getLogFile());
        env.put("&logMessage", new logMessage());
    }

    public void scriptUnloaded(ScriptInstance script) {
    }

    private class SessionUI
    implements Function {
        private SessionUI() {
        }

        public Scalar evaluate(final String f, ScriptInstance si, Stack locals) {
            Scalar value = (Scalar)locals.pop();
            final int asInt = value.intValue();
            final String asString = value.toString();
            ClientUtils.invokeLater(new Runnable(){

                public void run() {
                    GlobalCapabilities gc = SessionOperators.this.getCapabilities().getGlobalCapabilities();
                    SessionManager sm = gc.getSessionManager();
                    if (f.equals("&activateSession")) {
                        sm.setSelectedIndex(asInt);
                    }
                    if (f.equals("&setSessionColor")) {
                        sm.setForegroundAt(sm.getIndexFor(SessionOperators.this.getCapabilities()), Color.decode(asString));
                    }
                    if (f.equals("&setSessionText")) {
                        sm.setTitleAt(sm.getIndexFor(SessionOperators.this.getCapabilities()), asString);
                    }
                }
            });
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getActiveSessionId
    implements Function {
        private getActiveSessionId() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GlobalCapabilities gc = SessionOperators.this.getCapabilities().getGlobalCapabilities();
            SessionManager sm = gc.getSessionManager();
            return SleepUtils.getScalar(sm.getSelectedIndex());
        }
    }

    private class getSessionId
    implements Function {
        private getSessionId() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GlobalCapabilities gc = SessionOperators.this.getCapabilities().getGlobalCapabilities();
            SessionManager sm = gc.getSessionManager();
            return SleepUtils.getScalar(sm.getIndexFor(SessionOperators.this.getCapabilities()));
        }
    }

    private class getTotalSessions
    implements Function {
        private getTotalSessions() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GlobalCapabilities gc = SessionOperators.this.getCapabilities().getGlobalCapabilities();
            SessionManager sm = gc.getSessionManager();
            return SleepUtils.getScalar(sm.getTabCount());
        }
    }

    private class getSessionColor
    implements Function {
        private getSessionColor() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GlobalCapabilities gc = SessionOperators.this.getCapabilities().getGlobalCapabilities();
            SessionManager sm = gc.getSessionManager();
            return SleepUtils.getScalar(sm.getForegroundAt(BridgeUtilities.getInt(locals, sm.getIndexFor(SessionOperators.this.getCapabilities()))).getRGB());
        }
    }

    private class callCommandInSession
    implements Function {
        private callCommandInSession() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GlobalCapabilities gc = SessionOperators.this.getCapabilities().getGlobalCapabilities();
            SessionManager sm = gc.getSessionManager();
            sm.getSpecificSession(BridgeUtilities.getInt(locals, 0)).executeCommand(locals.pop().toString());
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getSessionText
    implements Function {
        private getSessionText() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GlobalCapabilities gc = SessionOperators.this.getCapabilities().getGlobalCapabilities();
            SessionManager sm = gc.getSessionManager();
            return SleepUtils.getScalar(sm.getTitleAt(BridgeUtilities.getInt(locals, sm.getIndexFor(SessionOperators.this.getCapabilities()))));
        }
    }

    private class isServerSecure
    implements Function {
        private isServerSecure() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            if (((SessionOperators)SessionOperators.this).getCapabilities().getSocketConnection().getSocketInformation().isSecure) {
                return SleepUtils.getScalar("true");
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class isServerConnected
    implements Function {
        private isServerConnected() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            if (((SessionOperators)SessionOperators.this).getCapabilities().getSocketConnection().getSocketInformation().isConnected) {
                return SleepUtils.getScalar("true");
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getServerPassword
    implements Function {
        private getServerPassword() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getScalar(((SessionOperators)SessionOperators.this).getCapabilities().getSocketConnection().getSocketInformation().password);
        }
    }

    private class getServerNetwork
    implements Function {
        private getServerNetwork() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getScalar(((SessionOperators)SessionOperators.this).getCapabilities().getSocketConnection().getSocketInformation().network);
        }
    }

    private class getServerPort
    implements Function {
        private getServerPort() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getScalar(((SessionOperators)SessionOperators.this).getCapabilities().getSocketConnection().getSocketInformation().port);
        }
    }

    private class getServerName
    implements Function {
        private getServerName() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getScalar(((SessionOperators)SessionOperators.this).getCapabilities().getSocketConnection().getSocketInformation().hostname);
        }
    }

    private class logMessage
    implements Function {
        private logMessage() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            SessionOperators.this.getCapabilities().getUserInterface().logMessage(BridgeUtilities.getString(locals, "%STATUS%"), BridgeUtilities.getString(locals, ""));
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getLogFile
    implements Function {
        private getLogFile() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getScalar(BuiltInLogger.getLogFileName(SessionOperators.this.getCapabilities().getSocketConnection().getSocketInformation(), BridgeUtilities.getString(locals, "%STATUS%")));
        }
    }
}

