/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.mdi;

import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.ClientWindowListener;

public class ClientInternalWindow
extends JInternalFrame
implements ClientWindow,
InternalFrameListener {
    protected LinkedList clisteners = new LinkedList();
    protected ClientWindowEvent cevent = new ClientWindowEvent(this);
    protected boolean isOpen = false;

    public ClientInternalWindow() {
        super("", true, true, true, true);
        this.addInternalFrameListener(this);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setIcon(ImageIcon i) {
        this.setFrameIcon(i);
    }

    public void addWindowListener(ClientWindowListener l) {
        this.clisteners.add(l);
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        ListIterator i = this.clisteners.listIterator();
        while (i.hasNext()) {
            ClientWindowListener temp = (ClientWindowListener)i.next();
            temp.onActive(this.cevent);
        }
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
        ListIterator i = this.clisteners.listIterator();
        while (i.hasNext()) {
            ClientWindowListener temp = (ClientWindowListener)i.next();
            temp.onInactive(this.cevent);
        }
    }

    public void internalFrameClosed(InternalFrameEvent e) {
        ListIterator i = this.clisteners.listIterator();
        while (i.hasNext()) {
            ClientWindowListener temp = (ClientWindowListener)i.next();
            temp.onClose(this.cevent);
        }
    }

    public void internalFrameClosing(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    public void internalFrameIconified(InternalFrameEvent e) {
        ListIterator i = this.clisteners.listIterator();
        while (i.hasNext()) {
            ClientWindowListener temp = (ClientWindowListener)i.next();
            temp.onMinimize(this.cevent);
        }
    }

    public void internalFrameOpened(InternalFrameEvent e) {
        ListIterator i = this.clisteners.listIterator();
        while (i.hasNext()) {
            ClientWindowListener temp = (ClientWindowListener)i.next();
            temp.onOpen(this.cevent);
        }
    }

    public void closeWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ClientInternalWindow.this.setClosed(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setMaximum(boolean b) {
        try {
            super.setMaximum(b);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setIcon(boolean b) {
        try {
            super.setIcon(b);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTitle(String aTitle) {
        this.title = aTitle;
        this.revalidate();
        this.repaint();
    }

    public void show() {
        this.isOpen = true;
        super.show();
    }

    public void activate() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    if (!ClientInternalWindow.this.isOpen) {
                        ClientInternalWindow.this.show();
                    }
                    ClientInternalWindow.this.setSelected(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

