/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.mdi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.KeyBindings;
import rero.gui.background.BackgroundDesktop;
import rero.gui.mdi.ClientInternalWindow;
import rero.gui.toolkit.OrientedToolBar;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.ClientWindowListener;
import rero.gui.windows.StatusWindow;
import rero.gui.windows.SwitchBarOptions;
import rero.gui.windows.WindowManager;
import rero.util.ClientUtils;

public class ClientDesktop
extends WindowManager
implements ClientWindowListener,
ClientStateListener {
    protected JDesktopPane desktop;

    public void init() {
        this.desktop = new JDesktopPane();
        this.switchbar = new OrientedToolBar();
        this.setLayout(new BorderLayout());
        this.add((Component)this.desktop, "Center");
        this.switchOptions = new SwitchBarOptions(this, this.switchbar);
        this.windowMap = new HashMap();
        this.windows = new LinkedList();
        this.desktop.setDesktopManager(new MyModifiedDesktopManager());
        MantainActiveFocus temp = new MantainActiveFocus(this);
        BackgroundDesktop wallpaper = new BackgroundDesktop(this.desktop);
        wallpaper.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.desktop.add((Component)wallpaper, new Integer(Integer.MIN_VALUE));
    }

    public void addWindow(StatusWindow window, boolean selected) {
        ClientInternalWindow temp = new ClientInternalWindow();
        window.init(temp);
        Rectangle bounds = ClientState.getClientState().getBounds(window.getWindowType() + ".size", this.desktop.getSize(), new Dimension(480, 300));
        temp.setBounds(bounds);
        this.windowMap.put(window.getWindow(), window);
        this.windowMap.put(window.getButton(), window);
        window.getWindow().addWindowListener(this);
        window.getButton().addActionListener(this);
        this.addToSwitchbar(window);
        this.desktop.add((JInternalFrame)((Object)window.getWindow()));
        if (!selected) {
            temp.setVisible(false);
        } else {
            window.getWindow().show();
        }
        ClientUtils.invokeLater(new Runnable(){

            public void run() {
                if (ClientDesktop.this.desktop.getSelectedFrame() != null && !ClientDesktop.this.desktop.getSelectedFrame().isSelected()) {
                    try {
                        ClientDesktop.this.refreshFocus(ClientDesktop.this.desktop.getSelectedFrame());
                        ClientDesktop.this.desktop.getSelectedFrame().setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    ClientDesktop.this.desktop.repaint();
                }
            }
        });
    }

    public void onActive(ClientWindowEvent ev) {
        StatusWindow temp = this.getWindowFor(ev.getSource());
        this.doActivate(temp);
    }

    public void onInactive(ClientWindowEvent ev) {
        this.doDeactivate(this.getWindowFor(ev.getSource()));
    }

    public void onMinimize(ClientWindowEvent ev) {
        boolean wasSelected = ev.getSource().isSelected();
        this.doDeactivate(this.getWindowFor(ev.getSource()));
        if (wasSelected) {
            int index = this.windows.indexOf(this.getWindowFor(ev.getSource()));
            this.newActive(index, false);
            this.refreshFocus(this.desktop.getSelectedFrame());
        }
    }

    public void onOpen(ClientWindowEvent ev) {
        StatusWindow temp = this.getWindowFor(ev.getSource());
        this.doActivate(temp);
    }

    public void onClose(ClientWindowEvent ev) {
        int index = this.windows.indexOf(this.getWindowFor(ev.getSource()));
        boolean wasSelected = ev.getSource().isSelected();
        ClientWindow window = ev.getSource();
        StatusWindow temp = (StatusWindow)this.windowMap.get(window);
        this.saveBounds(temp);
        this.switchbar.remove(temp.getButton());
        this.windowMap.remove(window);
        this.windowMap.remove(temp.getButton());
        this.windowMap.remove(temp.getWindow());
        this.windows.remove(temp);
        this.switchbar.validate();
        this.switchbar.repaint();
        if (this.desktop.getSelectedFrame() == null) {
            this.newActive(index, true);
            this.refreshFocus(this.desktop.getSelectedFrame());
        }
    }

    public StatusWindow getActiveWindow() {
        JInternalFrame f = this.desktop.getSelectedFrame();
        return this.getWindowFor(f);
    }

    protected void doActivate(StatusWindow window) {
        try {
            JInternalFrame temp = (JInternalFrame)((Object)window.getWindow());
            if (!((ClientInternalWindow)window.getWindow()).isOpen()) {
                window.getWindow().show();
            }
            if (!temp.isSelected()) {
                JInternalFrame[] ftemp = this.desktop.getAllFrames();
                for (int x = 0; x < ftemp.length; ++x) {
                    if (!ftemp[x].isSelected()) continue;
                    ftemp[x].setSelected(false);
                }
            }
            if (temp.isIcon()) {
                temp.setIcon(false);
            }
            this.desktop.setSelectedFrame(temp);
            window.getButton().setSelected(true);
            temp.setSelected(true);
            if (window.isLegalWindow()) {
                window.getInput().requestFocus();
            }
            this.saveBounds(window);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    private void saveBounds(StatusWindow window) {
        JInternalFrame temp = (JInternalFrame)((Object)window.getWindow());
        if (window.getWindow().isMaximum()) {
            ClientState.getClientState().setBounds(window.getWindowType() + ".size", new Rectangle(0, 0, (int)this.desktop.getSize().getWidth(), (int)this.desktop.getSize().getHeight()));
        } else {
            ClientState.getClientState().setBounds(window.getWindowType() + ".size", temp.getBounds());
        }
    }

    public void refreshFocus(JInternalFrame f) {
        if (f != null && this.isShowing() && this.getWindowFor(f).isLegalWindow() && !KeyBindings.is_dialog_active) {
            this.getWindowFor(f).getInput().requestFocus();
        }
    }

    protected void doDeactivate(StatusWindow window) {
        JInternalFrame temp = (JInternalFrame)((Object)window.getWindow());
        if (temp.isSelected()) {
            try {
                temp.setIcon(true);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        window.getButton().setSelected(false);
        try {
            temp.setSelected(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int totalOpenWindows() {
        int wincount = 0;
        for (int x = 0; x < this.desktop.getAllFrames().length; ++x) {
            JInternalFrame cwin = this.desktop.getAllFrames()[x];
            if (cwin.isIcon()) continue;
            ++wincount;
        }
        return wincount;
    }

    public void cascadeWindows() {
        Dimension size = this.desktop.getSize();
        int width = size.width * 4 / 5;
        int height = size.height * 2 / 3;
        int total = this.totalOpenWindows();
        if (total <= 0) {
            return;
        }
        JInternalFrame[] frames = this.desktop.getAllFrames();
        int pos = total - 1;
        for (int x = 0; x < frames.length; ++x) {
            try {
                if (frames[x].isIcon()) continue;
                try {
                    frames[x].setMaximum(false);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                frames[x].setSize(width, height);
                frames[x].setLocation(pos * 20, pos * 20);
                --pos;
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void tileWindows() {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        int total = this.totalOpenWindows();
        if (total <= 0) {
            return;
        }
        int numcols = (int)Math.sqrt(total);
        int numrows = total / numcols;
        if (total % numcols != 0) {
            ++numrows;
        }
        Dimension size = this.desktop.getSize();
        int width = size.width / numcols;
        int height = size.height / numrows;
        int ypos = 0;
        int winno = 1;
        for (int z = 0; z < frames.length; ++z) {
            if (frames[z].isIcon()) continue;
            try {
                frames[z].setMaximum(false);
            }
            catch (Exception ex) {
                // empty catch block
            }
            frames[z].setSize(new Dimension(width, height));
            frames[z].setLocation((winno - 1) * width, ypos);
            if (winno == numcols) {
                winno = 0;
                ypos += height;
            }
            ++winno;
        }
    }

    private class MantainActiveFocus
    extends ComponentAdapter {
        protected ClientDesktop desktop;

        public MantainActiveFocus(ClientDesktop mine) {
            this.desktop = mine;
            this.desktop.addComponentListener(this);
        }

        public void componentShown(ComponentEvent e) {
            JDesktopPane temp = this.desktop.desktop;
            if (temp.getSelectedFrame() != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            if (!MantainActiveFocus.this.desktop.desktop.getSelectedFrame().isSelected()) {
                                MantainActiveFocus.this.desktop.desktop.getSelectedFrame().setSelected(true);
                            }
                            MantainActiveFocus.this.desktop.refreshFocus(MantainActiveFocus.this.desktop.desktop.getSelectedFrame());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                temp.repaint();
            }
        }
    }

    protected class MyModifiedDesktopManager
    extends DefaultDesktopManager {
        protected MyModifiedDesktopManager() {
        }

        public void closeFrame(JInternalFrame f) {
        }

        public void iconifyFrame(JInternalFrame f) {
            boolean findNew = f.isSelected();
            f.setVisible(false);
            f.getParent().repaint(f.getX(), f.getY(), f.getWidth(), f.getHeight());
        }

        public void deiconifyFrame(JInternalFrame f) {
            f.setVisible(true);
        }

        public void dragFrame(JComponent f, int newX, int newY) {
            super.dragFrame(f, newX, newY);
            if (ClientDesktop.this.isRelative) {
                // empty if block
            }
        }

        public void endDraggingFrame(JComponent f) {
            super.endDraggingFrame(f);
            if (ClientDesktop.this.isRelative) {
                f.repaint();
            }
        }
    }
}

