/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.input;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.input.InputBorder;
import rero.gui.input.InputListener;
import rero.gui.input.UserInputEvent;
import text.AttributedText;
import text.ModifyColorMapDialog;
import text.TextSource;

public class InputField
extends JTextField
implements KeyListener,
ActionListener,
MouseListener,
ClientStateListener {
    protected Border defaultBorder;
    protected LinkedList listeners;
    protected UserInputEvent event;
    private ArrayList commandHistory;
    private ListIterator commandIterator;
    private int maxCommands = 30;
    private boolean previousKeyUpArrow = true;
    protected InputBorder indent;

    public void mouseClicked(MouseEvent ev) {
        AttributedText temp;
        if (ev.getButton() == 1 && ev.isShiftDown() && this.indent != null && (temp = this.indent.getAttributes().getAttributesAt(ev.getX() - this.defaultBorder.getBorderInsets((Component)this).left)) != null) {
            if (temp.backIndex != -1 && ev.isControlDown()) {
                ModifyColorMapDialog.showModifyColorMapDialog((JComponent)ev.getSource(), temp.backIndex);
            } else {
                ModifyColorMapDialog.showModifyColorMapDialog((JComponent)ev.getSource(), temp.foreIndex);
            }
            this.repaint();
        }
    }

    public boolean isFocusable() {
        return true;
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mousePressed(MouseEvent ev) {
    }

    public void mouseReleased(MouseEvent ev) {
    }

    public InputField() {
        this.setUI(new BasicTextFieldUI());
        this.setOpaque(false);
        this.defaultBorder = BorderFactory.createEmptyBorder(1, 2, 1, 1);
        this.setBorder(this.defaultBorder);
        this.addActionListener(this);
        this.addKeyListener(this);
        this.listeners = new LinkedList();
        this.event = new UserInputEvent();
        this.event.source = this;
        this.indent = null;
        this.addMouseListener(this);
        this.rehashColors();
        ClientState.getClientState().addClientStateListener("ui.editcolor", this);
        ClientState.getClientState().addClientStateListener("ui.font", this);
        this.commandHistory = new ArrayList(this.maxCommands + 1);
        this.commandIterator = this.commandHistory.listIterator();
    }

    public void propertyChanged(String name, String parms) {
        this.rehashColors();
    }

    public void rehashColors() {
        Color temp = ClientState.getClientState().getColor("ui.editcolor", ClientDefaults.ui_editcolor);
        this.setForeground(temp);
        this.setCaretColor(temp.brighter());
        this.setFont(ClientState.getClientState().getFont("ui.font", ClientDefaults.ui_font));
        this.revalidate();
    }

    public void actionPerformed(ActionEvent ev) {
        this.event.text = ev.getActionCommand();
        if (this.event.text.length() <= 0) {
            this.fireInputEvent();
            return;
        }
        this.fireInputEvent();
    }

    public void addInputListener(InputListener l) {
        this.listeners.addFirst(l);
    }

    public void fireInputEvent() {
        ListIterator i = this.listeners.listIterator();
        this.addToHistory(this.event.text);
        this.setText("");
        while (i.hasNext()) {
            InputListener temp = (InputListener)i.next();
            temp.onInput(this.event);
        }
        this.resetIterator(false);
        this.event.reset();
    }

    public String getIndent() {
        if (this.indent != null) {
            return this.indent.getText();
        }
        return "";
    }

    public void setIndent(String text) {
        if (text != null) {
            this.indent = new InputBorder(text);
            this.setBorder(new CompoundBorder(this.defaultBorder, this.indent));
        } else {
            this.setBorder(this.defaultBorder);
            this.indent = null;
        }
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\b' && this.getText().length() == 0) {
            e.consume();
        }
    }

    public String getCurrentText() {
        return this.getText();
    }

    public void keyPressed(KeyEvent e) {
        if (e.getModifiers() == 2) {
            int caretpos = this.getCaretPosition() + 1;
            switch (e.getKeyCode()) {
                case 75: {
                    this.setText(this.getText().substring(0, this.getCaretPosition()) + '\u0003' + this.getText().substring(this.getCaretPosition(), this.getText().length()));
                    this.setCaretPosition(caretpos);
                    e.consume();
                    return;
                }
                case 85: {
                    this.setText(this.getText().substring(0, this.getCaretPosition()) + '\u001f' + this.getText().substring(this.getCaretPosition(), this.getText().length()));
                    this.setCaretPosition(caretpos);
                    e.consume();
                    return;
                }
                case 66: {
                    this.setText(this.getText().substring(0, this.getCaretPosition()) + '\u0002' + this.getText().substring(this.getCaretPosition(), this.getText().length()));
                    this.setCaretPosition(caretpos);
                    e.consume();
                    return;
                }
                case 79: {
                    this.setText(this.getText().substring(0, this.getCaretPosition()) + '\u000f' + this.getText().substring(this.getCaretPosition(), this.getText().length()));
                    this.setCaretPosition(caretpos);
                    e.consume();
                    return;
                }
                case 82: {
                    this.setText(this.getText().substring(0, this.getCaretPosition()) + '\u0016' + this.getText().substring(this.getCaretPosition(), this.getText().length()));
                    this.setCaretPosition(caretpos);
                    e.consume();
                    return;
                }
            }
        }
        if (e.getKeyCode() == 10 && e.getModifiers() != 0) {
            this.resetIterator();
            this.event.text = this.getText();
            this.fireInputEvent();
            e.consume();
            return;
        }
        if (e.getKeyCode() == 38) {
            if (this.commandIterator.hasPrevious()) {
                String previous = String.valueOf(this.commandIterator.previous());
                if (!this.previousKeyUpArrow && this.commandIterator.hasPrevious()) {
                    this.setText(String.valueOf(this.commandIterator.previous()));
                } else {
                    this.setText(previous);
                }
            } else {
                e.consume();
            }
            this.previousKeyUpArrow = true;
        }
        if (e.getKeyCode() == 40) {
            if (this.commandIterator.hasNext()) {
                if (this.commandIterator.hasNext() && this.commandIterator.nextIndex() + 1 == this.commandHistory.size() && this.previousKeyUpArrow) {
                    this.resetIterator(false);
                    this.previousKeyUpArrow = true;
                    this.setText("");
                } else {
                    String next = String.valueOf(this.commandIterator.next());
                    if (this.previousKeyUpArrow && this.commandIterator.hasNext()) {
                        this.setText(String.valueOf(this.commandIterator.next()));
                    } else {
                        this.setText(next);
                    }
                    this.previousKeyUpArrow = false;
                }
            } else {
                this.setText("");
                Object next = null;
                this.previousKeyUpArrow = true;
            }
            e.consume();
        }
    }

    private void resetIterator() {
        this.resetIterator(true);
    }

    private void resetIterator(boolean resetToBeginning) {
        if (resetToBeginning) {
            while (this.commandIterator.hasPrevious()) {
                this.commandIterator.previous();
            }
        } else {
            while (this.commandIterator.hasNext()) {
                this.commandIterator.next();
            }
        }
    }

    private void addToHistory(String text) {
        this.commandExistsInHistory(text, true);
        this.resetIterator(false);
        this.commandIterator.add(text);
        if (this.commandHistory.size() == this.maxCommands + 1 && this.maxCommands > 0) {
            this.resetIterator();
            this.commandIterator.remove();
            this.resetIterator(false);
        }
    }

    private boolean commandExistsInHistory(String cmd, boolean delete) {
        this.resetIterator();
        while (this.commandIterator.hasNext()) {
            if (!this.commandIterator.next().equals(cmd)) continue;
            if (delete) {
                this.commandIterator.remove();
            }
            return true;
        }
        return false;
    }

    public void keyReleased(KeyEvent e) {
    }

    public void paint(Graphics g) {
        TextSource.initGraphics(g);
        super.paint(g);
    }

    protected Document createDefaultModel() {
        return new InputDocument();
    }

    class InputDocument
    extends PlainDocument {
        InputDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str.indexOf(10) == -1) {
                super.insertString(offs, str, a);
                return;
            }
            while (str.indexOf(10) > -1) {
                InputField.this.event.text = str.substring(0, str.indexOf(10));
                if (InputField.this.getCurrentText().length() > 0) {
                    super.insertString(offs, InputField.this.event.text, a);
                    InputField.this.event.text = InputField.this.getCurrentText();
                }
                InputField.this.fireInputEvent();
                if (str.indexOf(10) == str.length()) {
                    return;
                }
                str = str.substring(str.indexOf(10) + 1, str.length());
            }
            if (str.length() > 0) {
                InputField.this.event.text = str;
                InputField.this.fireInputEvent();
            }
        }
    }
}

