/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.background;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;

public class ManagedImage {
    protected VolatileImage hwImage;
    protected BufferedImage swImage;
    protected Component source;

    private void createImage() {
        this.hwImage = this.source.getGraphicsConfiguration().createCompatibleVolatileImage(this.getWidth(), this.getHeight());
    }

    private void renderImage() {
        Graphics2D g = this.hwImage.createGraphics();
        g.drawImage((Image)this.swImage, 0, 0, null);
        g.dispose();
    }

    public ManagedImage(BufferedImage _image, Component c) {
        this.source = c;
        this.swImage = _image;
        this.createImage();
        this.renderImage();
    }

    public int getWidth() {
        return this.swImage.getWidth();
    }

    public int getHeight() {
        return this.swImage.getHeight();
    }

    public Image getDrawableImage() {
        int state = this.hwImage.validate(this.source.getGraphicsConfiguration());
        if (state == 1) {
            this.renderImage();
        } else if (state == 2) {
            this.createImage();
            this.renderImage();
        }
        if (this.hwImage.contentsLost()) {
            System.out.println("Resorting to software image...  worthless peice of crap");
            return this.swImage;
        }
        System.out.println("hwImage: " + this.hwImage.getCapabilities());
        return this.hwImage;
    }
}

