/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.background;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.ImageIcon;
import rero.gui.background.BackgroundProperties;

public class BackgroundUtil {
    public static final int STYLE_TILE = 0;
    public static final int STYLE_CENTER = 1;
    public static final int STYLE_FILL = 2;
    public static final int STYLE_STRETCHED = 3;
    public static final int BG_DEFAULT = 0;
    public static final int BG_SOLID = 1;
    public static final int BG_TRANSPARENT = 2;
    public static final int BG_IMAGE = 3;

    public static void drawBackground(Component source, Graphics g, BackgroundProperties bgConfig) {
        if (bgConfig.getImage(source) == null) {
            BackgroundUtil.drawSafeBackground(source, g, bgConfig);
            return;
        }
        switch (bgConfig.getStyle()) {
            case 0: {
                BackgroundUtil.drawImageTiled(source, g, bgConfig);
                break;
            }
            case 2: {
                BackgroundUtil.drawImageFill(source, g, bgConfig);
                break;
            }
            case 3: {
                BackgroundUtil.drawImageStretched(source, g, bgConfig);
                break;
            }
            case 1: {
                BackgroundUtil.drawImageCentered(source, g, bgConfig);
                break;
            }
            default: {
                BackgroundUtil.drawImageTiled(source, g, bgConfig);
            }
        }
    }

    public static void drawTintedTransparency(Component source, Graphics g, BackgroundProperties bgProperties) {
        if (bgProperties.getTint() > 0.0f) {
            int x = g.getClipBounds().x;
            int y = g.getClipBounds().y;
            int width = g.getClipBounds().width;
            int height = g.getClipBounds().height;
            g.setColor(bgProperties.getColor());
            Graphics2D g2 = (Graphics2D)g;
            Composite oc = g2.getComposite();
            AlphaComposite ac = AlphaComposite.getInstance(3, bgProperties.getTint());
            g2.setComposite(ac);
            g2.fillRect(x, y, width, height);
            g2.setComposite(oc);
        }
    }

    public static void drawSafeBackground(Component source, Graphics g, BackgroundProperties bgProperties) {
        int x = g.getClipBounds().x;
        int y = g.getClipBounds().y;
        int width = g.getClipBounds().width;
        int height = g.getClipBounds().height;
        g.setColor(bgProperties.getColor());
        g.fillRect(x, y, width, height);
    }

    public static void drawImageFill(Component source, Graphics g, BackgroundProperties properties) {
        Image temp = properties.getTransformedImage();
        Dimension compare = null;
        int tx = 0;
        int ty = 0;
        if (properties.isRelative()) {
            compare = Toolkit.getDefaultToolkit().getScreenSize();
            tx = Math.abs(source.getLocationOnScreen().x) % Toolkit.getDefaultToolkit().getScreenSize().width;
            ty = Math.abs(source.getLocationOnScreen().y) % Toolkit.getDefaultToolkit().getScreenSize().height;
        } else {
            compare = source.getSize();
        }
        if (temp == null || temp.getWidth(null) != (int)compare.getWidth() || temp.getHeight(null) != (int)compare.getHeight()) {
            Image imageData = properties.getImage(source);
            Image cached = source.createImage((int)compare.getWidth(), (int)compare.getHeight());
            Graphics2D g2 = (Graphics2D)cached.getGraphics();
            g2.drawImage(imageData, 0, 0, (int)compare.getWidth(), (int)compare.getHeight(), null);
            g2.dispose();
            properties.setTransformedImage(cached);
            g.drawImage(cached, 0 - tx, 0 - ty, null);
            return;
        }
        g.drawImage(temp, 0 - tx, 0 - ty, null);
    }

    public static void drawImageCentered(Component source, Graphics g, BackgroundProperties properties) {
        Image temp = properties.getTransformedImage();
        Dimension compare = null;
        int tx = 0;
        int ty = 0;
        if (properties.isRelative()) {
            compare = Toolkit.getDefaultToolkit().getScreenSize();
            tx = Math.abs(source.getLocationOnScreen().x) % Toolkit.getDefaultToolkit().getScreenSize().width;
            ty = Math.abs(source.getLocationOnScreen().y) % Toolkit.getDefaultToolkit().getScreenSize().height;
        } else {
            compare = source.getSize();
        }
        if (temp == null || temp.getWidth(null) != (int)compare.getWidth() || temp.getHeight(null) != (int)compare.getHeight()) {
            Image imageData = properties.getImage(source);
            Image cached = source.createImage((int)compare.getWidth(), (int)compare.getHeight());
            int x_offset = ((int)compare.getWidth() - imageData.getWidth(null)) / 2;
            int y_offset = ((int)compare.getHeight() - imageData.getHeight(null)) / 2;
            Graphics2D g2 = (Graphics2D)cached.getGraphics();
            g2.setColor(properties.getColor());
            g2.fillRect(0, 0, (int)compare.getWidth(), (int)compare.getHeight());
            g2.drawImage(imageData, x_offset, y_offset, imageData.getWidth(null), imageData.getHeight(null), null);
            g2.dispose();
            properties.setTransformedImage(cached);
            g.drawImage(cached, 0 - tx, 0 - ty, null);
            return;
        }
        g.drawImage(temp, 0 - tx, 0 - ty, null);
    }

    public static void drawImageStretched(Component source, Graphics g, BackgroundProperties properties) {
        Image temp = properties.getTransformedImage();
        Dimension compare = null;
        int tx = 0;
        int ty = 0;
        if (properties.isRelative()) {
            compare = Toolkit.getDefaultToolkit().getScreenSize();
            tx = Math.abs(source.getLocationOnScreen().x) % Toolkit.getDefaultToolkit().getScreenSize().width;
            ty = Math.abs(source.getLocationOnScreen().y) % Toolkit.getDefaultToolkit().getScreenSize().height;
        } else {
            compare = source.getSize();
        }
        if (temp == null || temp.getWidth(null) != (int)compare.getWidth() || temp.getHeight(null) != (int)compare.getHeight()) {
            float y_diff;
            Image imageData = properties.getImage(source);
            Image cached = source.createImage((int)compare.getWidth(), (int)compare.getHeight());
            float x_diff = (float)compare.getWidth() / (float)imageData.getWidth(null);
            float ratio = x_diff > (y_diff = (float)compare.getHeight() / (float)imageData.getHeight(null)) ? x_diff : y_diff;
            int width = (int)((float)imageData.getWidth(null) * ratio);
            int height = (int)((float)imageData.getHeight(null) * ratio);
            int x_offset = ((int)compare.getWidth() - width) / 2;
            int y_offset = ((int)compare.getHeight() - height) / 2;
            Graphics2D g2 = (Graphics2D)cached.getGraphics();
            g2.setColor(properties.getColor());
            g2.fillRect(0, 0, (int)compare.getWidth(), (int)compare.getHeight());
            g2.drawImage(imageData, x_offset, y_offset, width, height, null);
            g2.dispose();
            properties.setTransformedImage(cached);
            g.drawImage(cached, 0 - tx, 0 - ty, null);
            return;
        }
        g.drawImage(temp, 0 - tx, 0 - ty, null);
    }

    public static void drawImageTiled(Component source, Graphics g, BackgroundProperties properties) {
        Image imageData = properties.getImage(source);
        int checkY = g.getClipBounds().y;
        int checkH = g.getClipBounds().height + checkY;
        checkY -= imageData.getHeight(null);
        int checkX = g.getClipBounds().x;
        int checkL = g.getClipBounds().width + checkX;
        checkX -= imageData.getWidth(null);
        int tx = 0;
        int ty = 0;
        if (properties.isRelative()) {
            tx = Math.abs(source.getLocationOnScreen().x) % Toolkit.getDefaultToolkit().getScreenSize().width;
            ty = Math.abs(source.getLocationOnScreen().y) % Toolkit.getDefaultToolkit().getScreenSize().height;
        }
        int x = source.getWidth();
        int y = source.getHeight();
        int y1 = 0 - ty;
        for (int x1 = 0 - tx; x1 < x; x1 += imageData.getWidth(null)) {
            while (y1 < y) {
                if (x1 >= checkX && x1 <= checkL && y1 >= checkY && y1 <= checkH) {
                    g.drawImage(imageData, x1, y1, null);
                }
                y1 += imageData.getHeight(null);
            }
            y1 = 0 - ty;
        }
    }

    public static Image getManagedImage(Component source, String file, float tint, Color solid) {
        if (!new File(file).exists()) {
            return null;
        }
        Image imageData = new ImageIcon(file).getImage();
        if (tint > 0.0f) {
            Image imageDataTinted = source.createImage(imageData.getWidth(null), imageData.getHeight(null));
            Graphics2D g2 = (Graphics2D)imageDataTinted.getGraphics();
            Composite oc = g2.getComposite();
            g2.drawImage(imageData, 0, 0, null);
            AlphaComposite ac = AlphaComposite.getInstance(3, tint);
            g2.setComposite(ac);
            g2.setColor(solid);
            g2.fillRect(0, 0, imageDataTinted.getWidth(null), imageDataTinted.getHeight(null));
            g2.dispose();
            return imageDataTinted;
        }
        return imageData;
    }
}

