/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.background;

import java.awt.Graphics;
import javax.swing.JToolBar;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.background.BackgroundProperties;
import rero.gui.background.BackgroundUtil;

public class BackgroundToolBar
extends JToolBar
implements ClientStateListener {
    protected static BackgroundProperties bgProperties;

    public BackgroundToolBar() {
        if (bgProperties == null) {
            bgProperties = new BackgroundProperties("statusbar", 0);
        }
        ClientState.getClientState().addClientStateListener("statusbar", this);
    }

    public boolean isOpaque() {
        return bgProperties.getType() == 0;
    }

    public void propertyChanged(String property, String parms) {
        this.repaint();
    }

    public void paint(Graphics g) {
        int x = g.getClipBounds().x;
        int y = g.getClipBounds().y;
        int width = g.getClipBounds().width;
        int height = g.getClipBounds().height;
        switch (bgProperties.getType()) {
            case 0: {
                super.paint(g);
                this.paintBorder(g);
                break;
            }
            case 1: {
                g.setColor(bgProperties.getColor());
                g.fillRect(x, y, width, height);
                this.paintChildren(g);
                break;
            }
            case 2: {
                BackgroundUtil.drawTintedTransparency(this, g, bgProperties);
                this.paintChildren(g);
                break;
            }
            case 3: {
                BackgroundUtil.drawBackground(this, g, bgProperties);
                this.paintChildren(g);
            }
        }
    }
}

