/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.background;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.background.BackgroundUtil;

public class BackgroundProperties
implements ClientStateListener {
    protected String type;
    protected int bgType;
    protected int bgStyle;
    protected Image image;
    protected Image transform;
    protected String name;
    protected Color bgColor;
    protected float bgTint;
    protected boolean isRelative;

    public boolean isRelative() {
        return this.isRelative;
    }

    public int getType() {
        return this.bgType;
    }

    public int getStyle() {
        return this.bgStyle;
    }

    public Color getColor() {
        return this.bgColor;
    }

    public float getTint() {
        return this.bgTint;
    }

    public BackgroundProperties(String type, int defaultType) {
        this(type, Color.white, defaultType);
    }

    public BackgroundProperties(String type, Color defaultColor, int defaultType) {
        this(type, defaultColor, defaultType, 0, 0.5f);
    }

    public BackgroundProperties(String _type, Color defaultColor, int defaultType, int defaultStyle, float defaultTint) {
        this.type = _type;
        ClientState.getClientState().addClientStateListener(this.type, this);
        this.init(defaultColor, defaultType, defaultStyle, defaultTint);
    }

    public void propertyChanged(String property, String parms) {
        this.init(this.bgColor, this.bgType, this.bgStyle, this.bgTint);
    }

    public void init(Color defaultColor, int defaultType, int defaultStyle, float defaultTint) {
        String _name = ClientState.getClientState().getString(this.type + ".image", "background.jpg");
        int _bgType = ClientState.getClientState().getInteger(this.type + ".bgtype", defaultType);
        Color _bgColor = ClientState.getClientState().getColor(this.type + ".color", defaultColor);
        float _bgTint = ClientState.getClientState().getFloat(this.type + ".tint", defaultTint);
        int _bgStyle = ClientState.getClientState().getInteger(this.type + ".bgstyle", defaultStyle);
        boolean _isRelative = ClientState.getClientState().isOption(this.type + ".relative", false);
        if (!_name.equals(this.name) || this.bgColor == null || this.bgType != _bgType || !this.bgColor.equals(_bgColor) || this.bgTint != _bgTint || this.bgStyle != _bgStyle || this.isRelative != _isRelative) {
            this.name = _name;
            this.bgType = _bgType;
            this.bgColor = _bgColor;
            this.bgTint = _bgTint;
            this.bgStyle = _bgStyle;
            this.isRelative = _isRelative;
            this.image = null;
            this.transform = null;
        }
    }

    public Image getImage(Component c) {
        if (this.image == null) {
            String imageName = ClientState.getClientState().getString(this.type + ".image", "background.jpg");
            this.image = BackgroundUtil.getManagedImage(c, imageName, this.bgTint, this.bgColor);
        }
        return this.image;
    }

    public Image getTransformedImage() {
        return this.transform;
    }

    public void setTransformedImage(Image i) {
        this.transform = i;
    }
}

