/*
 * Decompiled with CFR 0.152.
 */
package rero.gui.background;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.background.BackgroundProperties;
import rero.gui.background.BackgroundUtil;

public class BackgroundDesktop
extends JPanel
implements ClientStateListener {
    protected BackgroundProperties bgProperties;
    protected JComponent desktop;

    public BackgroundDesktop(JComponent pane) {
        this.desktop = pane;
        if (this.bgProperties == null) {
            this.bgProperties = new BackgroundProperties("desktop", 0);
        }
        ClientState.getClientState().addClientStateListener("desktop", this);
    }

    public Dimension getSize() {
        return this.desktop.getSize();
    }

    public void propertyChanged(String property, String parms) {
        this.repaint();
    }

    public void paint(Graphics g) {
        int x = g.getClipBounds().x;
        int y = g.getClipBounds().y;
        int width = g.getClipBounds().width;
        int height = g.getClipBounds().height;
        switch (this.bgProperties.getType()) {
            case 0: {
                break;
            }
            case 1: {
                g.setColor(this.bgProperties.getColor());
                g.fillRect(x, y, width, height);
                this.paintChildren(g);
                break;
            }
            case 3: {
                BackgroundUtil.drawBackground(this, g, this.bgProperties);
                this.paintChildren(g);
            }
        }
    }
}

