/*
 * Decompiled with CFR 0.152.
 */
package rero.gui;

import java.util.Iterator;
import java.util.Set;
import rero.gui.BuiltInLogger;
import rero.gui.IRCSession;
import rero.gui.script.WindowDataListener;
import rero.gui.windows.ChannelWindow;
import rero.gui.windows.QueryWindow;
import rero.gui.windows.StatusWindow;
import rero.ircfw.Channel;

public class UICapabilities {
    protected IRCSession clientSession;
    protected WindowDataListener listeners = null;
    protected BuiltInLogger logger = null;

    public UICapabilities(IRCSession _session) {
        this.clientSession = _session;
        this.logger = new BuiltInLogger(_session);
    }

    public void logMessage(String window, String text) {
        if (this.logger.isEnabled()) {
            this.logger.logMessage(window, text);
        }
    }

    public void setQuery(String query) {
        this.clientSession.getStatusWindow().setQuery(query);
    }

    public String getQuery() {
        return this.clientSession.getActiveWindow().getQuery();
    }

    public boolean isActive(String title) {
        return this.clientSession.getStatusWindow().getQuery().toLowerCase().equals(title.toLowerCase()) || this.clientSession.isWindow(title);
    }

    public boolean isWindow(String title) {
        return this.clientSession.isWindow(title);
    }

    protected boolean shouldContinue(String window, String text) {
        return text != null && (this.listeners == null || this.listeners.shouldContinue(window, text));
    }

    public void printActive(String text) {
        if (this.shouldContinue(this.clientSession.getActiveWindow().getQuery(), text)) {
            this.clientSession.getActiveWindow().flag();
            this.clientSession.getActiveWindow().getDisplay().addText(text);
            if (this.logger.isEnabled()) {
                this.logger.logMessage(this.clientSession.getActiveWindow().getName(), text);
            }
        }
    }

    public void printAll(String text) {
        Iterator i = this.clientSession.getAllWindows().iterator();
        while (i.hasNext()) {
            StatusWindow temp = (StatusWindow)i.next();
            if (!temp.isLegalWindow() || !this.shouldContinue(temp.getQuery(), text)) continue;
            temp.getDisplay().addText(text);
            if (!this.logger.isEnabled()) continue;
            this.logger.logMessage(temp.getName(), text);
        }
    }

    public void printStatus(String text) {
        if (this.shouldContinue(this.clientSession.getStatusWindow().getQuery(), text) && this.clientSession.getStatusWindow().getDisplay() != null) {
            this.clientSession.getStatusWindow().flag();
            this.clientSession.getStatusWindow().getDisplay().addText(text);
            if (this.logger.isEnabled()) {
                this.logger.logMessage("%STATUS%", text);
            }
        }
    }

    public void printNormal(String window, String text) {
        if (this.shouldContinue(window, text)) {
            StatusWindow temp = this.clientSession.getWindow(window);
            temp.flag();
            temp.getDisplay().addText(text);
            if (this.logger.isEnabled()) {
                this.logger.logMessage(temp.getName(), text);
            }
        }
    }

    public void printToTargets(Set targets, String text, boolean alwaysStatus) {
        boolean echoToStatus = false;
        boolean echoHasOccured = false;
        Iterator i = targets.iterator();
        String query = this.getQuery();
        while (i.hasNext()) {
            String target = (String)i.next();
            if (this.clientSession.isWindow(target)) {
                this.printNormal(target, text);
                echoHasOccured = true;
                if (!target.equals(query)) continue;
                alwaysStatus = false;
                continue;
            }
            echoToStatus = true;
        }
        if (echoToStatus || !echoHasOccured || alwaysStatus) {
            this.printStatus(text);
        }
    }

    public void printChunk(String window, String normal, String[] chunks, double percentage) {
        if (this.shouldContinue(window, normal)) {
            this.clientSession.getWindow(window).getDisplay().addTextTable(normal, chunks, percentage);
            if (this.logger.isEnabled()) {
                this.logger.logMessage(this.clientSession.getWindow(window).getName(), normal);
            }
        }
    }

    public void printRaw(String window, String text) {
        StatusWindow temp = this.clientSession.getWindow(window);
        if (window != null) {
            temp.flag();
            temp.getDisplay().addText(text);
            if (this.logger.isEnabled()) {
                this.logger.logMessage(temp.getName(), text);
            }
        }
    }

    public void clearScreen(String window) {
        if (window == null || window.length() == 0) {
            this.clientSession.getActiveWindow().getDisplay().clear();
        } else if ("%ALL%".equals(window)) {
            this.clientSession.getStatusWindow().getDisplay().clear();
            this.clientSession.getStatusWindow().unflag();
            Iterator i = this.clientSession.getAllWindows().iterator();
            while (i.hasNext()) {
                StatusWindow swindow = (StatusWindow)i.next();
                if (!swindow.isLegalWindow()) continue;
                swindow.getDisplay().clear();
                swindow.unflag();
            }
        } else {
            this.clientSession.getWindow(window).getDisplay().clear();
            this.clientSession.getWindow(window).unflag();
        }
    }

    public void openQueryWindow(String nickname, boolean selected) {
        if (!this.clientSession.isWindow(nickname)) {
            QueryWindow queryWindow = this.clientSession.createQueryWindow(nickname, selected);
        }
    }

    public void closeWindow(String window) {
        if (this.clientSession.isWindow(window)) {
            this.clientSession.getWindow(window).getWindow().closeWindow();
        }
    }

    public void openListWindow() {
        this.clientSession.createListWindow();
    }

    public void openDCCWindow() {
        this.clientSession.createDCCWindow();
    }

    public void openChannelWindow(Channel channel) {
        if (!this.clientSession.isWindow(channel.getName())) {
            ChannelWindow channelWindow = this.clientSession.createChannelWindow(channel);
        }
    }

    public void notifyActiveWindow() {
        this.clientSession.getActiveWindow().touch();
    }

    public void notifyWindow(String window) {
        this.clientSession.getWindow(window).touch();
    }

    public void renameWindow(String old, String newtitle) {
        this.clientSession.renameWindow(old, newtitle);
    }

    public void setListener(WindowDataListener l) {
        this.listeners = l;
    }

    public void showSearchDialog(String window) {
        StatusWindow temp = this.clientSession.getWindow(window);
        if (temp.isLegalWindow()) {
            if (window.equals("%STATUS%")) {
                window = "Status";
            }
            temp.getDisplay().showSearchDialog("Search " + window);
        }
    }
}

