/*
 * Decompiled with CFR 0.152.
 */
package rero.gui;

import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rero.bridges.menu.MenuBridge;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.config.StringList;
import rero.dialogs.server.Server;
import rero.dialogs.server.ServerData;
import rero.gui.GlobalCapabilities;
import rero.gui.GraphicalToolbar;
import rero.gui.IRCSession;
import rero.gui.KeyBindings;
import rero.gui.toolkit.MinimalTabUI;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.ClientWindowListener;
import rero.net.SocketEvent;
import rero.net.interfaces.SocketStatusListener;
import rero.test.QuickConnect;
import rero.util.ClientUtils;

public class SessionManager
extends JTabbedPane
implements ClientWindowListener,
SocketStatusListener,
ChangeListener,
ClientStateListener {
    protected HashMap sessions = new HashMap();
    protected IRCSession active = null;
    protected JFrame frame = null;
    protected MenuBridge bridge = null;
    protected PopupManager popups = null;
    protected KeyBindings keyb = null;
    protected String lastscript = "";
    protected long lastref = 0L;
    protected static GlobalCapabilities global;
    protected HashMap switchEventHashMap = new HashMap();

    public static GlobalCapabilities getGlobalCapabilities() {
        return global;
    }

    public void propertyChanged(String property, String parameter) {
        this.bridge = (MenuBridge)this.getActiveSession().getCapabilities().getDataStructure("menuBridge");
        ClientUtils.invokeLater(new Runnable(){

            public void run() {
                if (ClientState.getClientState().isOption("ui.showbar", true)) {
                    JMenuBar menu = new JMenuBar();
                    SessionManager.this.bridge.installMenubar(menu);
                    SessionManager.this.frame.setJMenuBar(menu);
                } else {
                    SessionManager.this.frame.setJMenuBar(null);
                }
                SessionManager.this.frame.validate();
            }
        });
    }

    public void stateChanged(ChangeEvent ev) {
        this.active = this.getSession(this.getSelectedComponent());
        if (this.getActiveSession() != null) {
            this.propertyChanged(null, null);
            GraphicalToolbar.stateChanged();
            this.getActiveSession().getCapabilities().dispatchEvent(this.switchEventHashMap);
        }
    }

    public SessionManager(JFrame _frame) {
        this.switchEventHashMap.put("$event", "session");
        this.setTabPlacement(3);
        global = new GlobalCapabilities(this);
        this.keyb = new KeyBindings(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyb);
        this.addChangeListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!ClientState.getClientState().isOption("ui.showtabs", true)) {
                    SessionManager.this.setUI(new MinimalTabUI());
                }
                StringList temp = ClientState.getClientState().getStringList("auto.connect");
                if (QuickConnect.IsQuickConnect()) {
                    SessionManager.this.addSession();
                    SessionManager.this.getSession(SessionManager.this.getComponentAt(0)).executeCommand(QuickConnect.GetInformation().getConnectCommand());
                } else if (temp.getList().size() == 0) {
                    SessionManager.this.addSession();
                } else {
                    ServerData sdata = ServerData.getServerData();
                    int y = 0;
                    Iterator i = temp.getList().iterator();
                    while (i.hasNext()) {
                        Server stemp = sdata.getServerByName(i.next().toString());
                        if (stemp == null) continue;
                        SessionManager.this.addSession();
                        SessionManager.this.getSession(SessionManager.this.getComponentAt(y)).executeCommand(stemp.getCommand());
                        ++y;
                    }
                }
                GraphicalToolbar.startup();
            }
        });
        this.frame = _frame;
        if (ClientState.getClientState().isOption("ui.showbar", true)) {
            this.frame.setJMenuBar(new JMenuBar());
        }
        if (this.getMouseListeners().length > 0) {
            this.removeMouseListener(this.getMouseListeners()[0]);
        }
        this.popups = new PopupManager();
        this.addMouseListener(this.popups);
        ClientState.getClientState().addClientStateListener("loaded.scripts", this);
        ClientState.getClientState().addClientStateListener("ui.showbar", this);
    }

    public IRCSession getActiveSession() {
        return this.active;
    }

    public IRCSession getSpecificSession(int index) {
        return this.getSession(this.getComponentAt(index));
    }

    public void addSession() {
        IRCSession session;
        this.active = session = new IRCSession();
        this.sessions.put(session.getStatusWindow().getWindow(), session);
        this.sessions.put(session.getCapabilities().getSocketConnection(), session);
        this.sessions.put(session.getCapabilities(), session);
        this.sessions.put(session.getDesktop(), session);
        session.getStatusWindow().getWindow().addWindowListener(this);
        session.getCapabilities().getSocketConnection().addSocketStatusListener(this);
        this.setSelectedComponent(this.add("not connected", session.getDesktop()));
        session.getClient().post();
        this.propertyChanged(null, null);
        this.revalidate();
        if (ClientState.getClientState().getString("user.nick", null) == null && !QuickConnect.IsQuickConnect()) {
            SessionManager.getGlobalCapabilities().showOptionDialog(null);
            session.getStatusWindow().getInput().requestFocus();
        }
    }

    public IRCSession getSession(Object key) {
        return (IRCSession)this.sessions.get(key);
    }

    public int getIndexFor(Object key) {
        IRCSession session = this.getSession(key);
        if (session == null) {
            return -1;
        }
        int n = this.indexOfComponent(session.getDesktop());
        if (n > this.getTabCount()) {
            return -1;
        }
        return n;
    }

    public void removeSession(IRCSession session) {
        Iterator i = this.sessions.values().iterator();
        while (i.hasNext()) {
            Object temp = i.next();
            if (temp != session) continue;
            i.remove();
        }
        long freememory = Runtime.getRuntime().freeMemory();
        this.remove(session.getDesktop());
        this.keyb.removeSession(session);
        session.cleanup();
        this.revalidate();
        System.gc();
        freememory = Runtime.getRuntime().freeMemory() - freememory;
        System.out.println("Freed a total of " + ClientUtils.formatBytes(freememory));
        if (this.getTabCount() <= 0) {
            this.addSession();
        }
        if (this.active == session) {
            this.stateChanged(null);
        }
    }

    public void onClose(ClientWindowEvent ev) {
        IRCSession source = this.getSession(ev.getSource());
        this.removeSession(source);
        if (source.getCapabilities().isConnected()) {
            source.getCapabilities().sendln("QUIT :Hey! Where'd my controlling terminal go?");
            source.getCapabilities().getSocketConnection().disconnect();
        }
    }

    public void onActive(ClientWindowEvent ev) {
    }

    public void onInactive(ClientWindowEvent ev) {
    }

    public void onMinimize(ClientWindowEvent ev) {
    }

    public void onOpen(ClientWindowEvent ev) {
    }

    public void setTabTitle(Object key, String text) {
        this.setTitleAt(this.getIndexFor(key), text);
    }

    public void socketStatusChanged(SocketEvent ev) {
        if (ev.data.isConnected) {
            if (this.getIndexFor(ev.socket) > -1) {
                this.setTitleAt(this.getIndexFor(ev.socket), ev.data.hostname);
            }
        } else if (this.getIndexFor(ev.socket) > -1) {
            this.setTitleAt(this.getIndexFor(ev.socket), "disconnected");
        }
        GraphicalToolbar.stateChanged();
    }

    public IRCSession getSessionAt(Point location) {
        if (this.indexAtLocation((int)location.getX(), (int)location.getY()) < 0) {
            return null;
        }
        return this.getSession(this.getComponentAt(this.indexAtLocation((int)location.getX(), (int)location.getY())));
    }

    protected class PopupManager
    extends MouseAdapter {
        protected PopupManager() {
        }

        public void maybeShowPopup(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                IRCSession temp = SessionManager.this.getSessionAt(ev.getPoint());
                if (temp == null) {
                    return;
                }
                SessionManager.this.bridge = (MenuBridge)temp.getCapabilities().getDataStructure("menuBridge");
                JPopupMenu menu = SessionManager.this.bridge.getPopupMenu("tab", null);
                if (menu == null) {
                    return;
                }
                menu.show((JComponent)ev.getComponent(), ev.getX(), ev.getY());
                ev.consume();
                return;
            }
        }

        public void mouseClicked(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            int idx;
            this.maybeShowPopup(e);
            if (e.getButton() == 1 && (idx = SessionManager.this.indexAtLocation(e.getX(), e.getY())) > -1) {
                SessionManager.this.setSelectedIndex(idx);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

