/*
 * Decompiled with CFR 0.152.
 */
package rero.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import rero.bridges.menu.MenuBridge;
import rero.client.Capabilities;
import rero.client.InternetRelayChatClient;
import rero.client.user.UserHandler;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.dcc.DataDCC;
import rero.gui.ClickableURLHandler;
import rero.gui.UICapabilities;
import rero.gui.mdi.ClientDesktop;
import rero.gui.script.UIScriptBridge;
import rero.gui.sdi.ClientPanel;
import rero.gui.windows.AboutWindow;
import rero.gui.windows.ChannelListDialog;
import rero.gui.windows.ChannelWindow;
import rero.gui.windows.ClientWindow;
import rero.gui.windows.ClientWindowEvent;
import rero.gui.windows.ClientWindowListener;
import rero.gui.windows.DCCListDialog;
import rero.gui.windows.QueryWindow;
import rero.gui.windows.ScriptedListDialog;
import rero.gui.windows.StatusWindow;
import rero.gui.windows.WindowManager;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;

public class IRCSession {
    protected WindowManager desktop;
    protected InternetRelayChatClient client = new InternetRelayChatClient();
    protected StatusWindow status;
    protected HashMap windows;
    protected UserHandler userInput;
    protected UIScriptBridge scriptBridge;
    protected ClientWindowStuff windowListener;
    protected ClickableURLHandler urlListener;
    private DCCListDialog dccListDialog = null;

    public void cleanup() {
        this.getCapabilities().cleanup();
    }

    public Capabilities getCapabilities() {
        return this.client.getCapabilities();
    }

    public void executeCommand(String command) {
        ((UserHandler)this.getCapabilities().getDataStructure("commands")).processCommand(command);
    }

    public IRCSession() {
        this.client.init(new UICapabilities(this));
        this.userInput = (UserHandler)this.client.getCapabilities().getDataStructure("commands");
        if (ClientState.getClientState().isOption("ui.sdi", ClientDefaults.ui_sdi)) {
            this.desktop = new ClientPanel();
        } else {
            this.desktop = new ClientDesktop();
            ((ClientDesktop)this.desktop).addMouseListener(new PopupManager());
        }
        this.windows = new HashMap();
        this.urlListener = new ClickableURLHandler();
        this.urlListener.installCapabilities(this.getCapabilities());
        this.windowListener = new ClientWindowStuff();
        this.scriptBridge = new UIScriptBridge(this);
        this.status = this.createStatusWindow();
        this.scriptBridge.windowCreated(this.status);
        this.status.getDisplay().addClickListener(this.urlListener);
    }

    public boolean isWindow(String name) {
        return this.windows.get(name.toUpperCase()) != null || name.equals("%STATUS%");
    }

    public StatusWindow getWindow(String name) {
        if (name == null || this.windows.get(name.toUpperCase()) == null) {
            return this.status;
        }
        return (StatusWindow)this.windows.get(name.toUpperCase());
    }

    public Collection getAllWindows() {
        return this.desktop.getAllWindows();
    }

    public InternetRelayChatClient getClient() {
        return this.client;
    }

    public StatusWindow getStatusWindow() {
        return this.status;
    }

    public boolean isStatus(StatusWindow window) {
        return window == this.status;
    }

    public WindowManager getDesktop() {
        return this.desktop;
    }

    public StatusWindow getActiveWindow() {
        StatusWindow temp = this.desktop.getActiveWindow();
        if (temp == null || !temp.isLegalWindow()) {
            return this.getStatusWindow();
        }
        return temp;
    }

    public StatusWindow getRealActiveWindow() {
        return this.desktop.getActiveWindow();
    }

    public void createAboutWindow() {
        AboutWindow contents = new AboutWindow();
        this.desktop.addWindow(contents, true);
        Thread fred = new Thread(contents);
        fred.start();
    }

    public void renameWindow(String name, String newname) {
        StatusWindow temp = (StatusWindow)this.windows.get(name.toUpperCase());
        StatusWindow temp2 = (StatusWindow)this.windows.get(newname.toUpperCase());
        if (temp != null && temp2 == null) {
            this.windows.remove(name.toUpperCase());
            this.windows.put(newname.toUpperCase(), temp);
            temp.setName(newname);
        }
    }

    public void createDCCWindow() {
        if (this.dccListDialog == null) {
            this.dccListDialog = new DCCListDialog();
            this.dccListDialog.installCapabilities(this.client.getCapabilities());
            this.desktop.addWindow(this.dccListDialog, true);
            this.windows.put(this.dccListDialog.getName().toUpperCase(), this.dccListDialog);
            this.scriptBridge.windowCreated(this.dccListDialog);
            this.dccListDialog.getWindow().addWindowListener(this.windowListener);
        } else if (!this.dccListDialog.isOpen()) {
            this.desktop.addWindow(this.dccListDialog, true);
            this.windows.put(this.dccListDialog.getName().toUpperCase(), this.dccListDialog);
            this.scriptBridge.windowCreated(this.dccListDialog);
            this.dccListDialog.getWindow().addWindowListener(this.windowListener);
        }
    }

    public ScriptedListDialog createSortedWindow(String title, String hook, Object data, LinkedList columns) {
        ScriptedListDialog contents = new ScriptedListDialog(title, hook, data, columns);
        contents.installCapabilities(this.client.getCapabilities());
        this.desktop.addWindow(contents, false);
        this.windows.put(title.toUpperCase(), contents);
        this.scriptBridge.windowCreated(contents);
        contents.getWindow().addWindowListener(this.windowListener);
        return contents;
    }

    public void createListWindow() {
        ChannelListDialog contents = new ChannelListDialog();
        contents.installCapabilities(this.client.getCapabilities());
        this.desktop.addWindow(contents, true);
        this.windows.put(contents.getName().toUpperCase(), contents);
        this.scriptBridge.windowCreated(contents);
        contents.getWindow().addWindowListener(this.windowListener);
    }

    public StatusWindow createStatusWindow() {
        StatusWindow contents = new StatusWindow();
        this.desktop.addWindow(contents, true);
        contents.getInput().addInputListener(this.userInput);
        contents.installCapabilities(this.client.getCapabilities());
        return contents;
    }

    public QueryWindow createQueryWindow(String user, boolean selected) {
        QueryWindow contents = new QueryWindow(user);
        this.desktop.addWindow(contents, selected);
        contents.getInput().addInputListener(this.userInput);
        contents.installCapabilities(this.client.getCapabilities());
        this.windows.put(user.toUpperCase(), contents);
        this.scriptBridge.windowCreated(contents);
        contents.getDisplay().addClickListener(this.urlListener);
        contents.getWindow().addWindowListener(this.windowListener);
        return contents;
    }

    public ChannelWindow createChannelWindow(Channel channel) {
        ChannelWindow contents = new ChannelWindow(channel);
        this.desktop.addWindow(contents, true);
        contents.getInput().addInputListener(this.userInput);
        contents.installCapabilities(this.client.getCapabilities());
        this.windows.put(channel.getName().toUpperCase(), contents);
        this.scriptBridge.windowCreated(contents);
        contents.getDisplay().addClickListener(this.urlListener);
        contents.getWindow().addWindowListener(this.windowListener);
        return contents;
    }

    public StatusWindow resolveClientWindow(ClientWindow temp) {
        Iterator i = this.windows.values().iterator();
        while (i.hasNext()) {
            StatusWindow x = (StatusWindow)i.next();
            if (x.getWindow() != temp) continue;
            return x;
        }
        return this.status;
    }

    public void postProcessWindow(StatusWindow window) {
        if (window instanceof ChannelWindow) {
            InternalDataList ircData;
            if (ClientState.getClientState().isOption("auto.part", true) && (ircData = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation")).getChannel(window.getName()) != null) {
                this.getCapabilities().sendln("PART " + window.getName());
            }
        } else if (window.getName().charAt(0) == '=' && window.isLegalWindow() && ClientState.getClientState().isOption("auto.chatclose", true)) {
            DataDCC dccData = (DataDCC)this.getCapabilities().getDataStructure("dcc");
            dccData.closeChat(window.getName().substring(1, window.getName().length()));
        }
    }

    protected void finalize() {
        System.out.println("FINALIZING IRC SESSION y0");
    }

    protected class PopupManager
    extends MouseAdapter {
        protected PopupManager() {
        }

        public void maybeShowPopup(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                MenuBridge bridge = (MenuBridge)IRCSession.this.client.getCapabilities().getDataStructure("menuBridge");
                JPopupMenu menu = bridge.getPopupMenu("background", null);
                if (menu == null) {
                    return;
                }
                menu.show((JComponent)ev.getComponent(), ev.getX(), ev.getY());
                ev.consume();
            }
        }

        public void mouseClicked(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }
    }

    protected class ClientWindowStuff
    implements ClientWindowListener {
        protected ClientWindowStuff() {
        }

        public void onActive(ClientWindowEvent ev) {
        }

        public void onOpen(ClientWindowEvent ev) {
        }

        public void onInactive(ClientWindowEvent ev) {
        }

        public void onMinimize(ClientWindowEvent ev) {
        }

        public void onClose(ClientWindowEvent ev) {
            ClientWindow temp = ev.getSource();
            Iterator i = IRCSession.this.windows.values().iterator();
            while (i.hasNext()) {
                StatusWindow x = (StatusWindow)i.next();
                if (x.getWindow() != temp) continue;
                IRCSession.this.postProcessWindow(x);
                i.remove();
                return;
            }
        }
    }
}

