/*
 * Decompiled with CFR 0.152.
 */
package rero.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.SessionManager;
import rero.gui.toolbar.AboutAction;
import rero.gui.toolbar.CascadeAction;
import rero.gui.toolbar.ChatAction;
import rero.gui.toolbar.ConnectAction;
import rero.gui.toolbar.DCCAction;
import rero.gui.toolbar.EvilAction;
import rero.gui.toolbar.HelpAction;
import rero.gui.toolbar.ListAction;
import rero.gui.toolbar.NotifyAction;
import rero.gui.toolbar.NotifyAction2;
import rero.gui.toolbar.OptionsAction;
import rero.gui.toolbar.ScriptAction;
import rero.gui.toolbar.SendAction;
import rero.gui.toolbar.TileAction;
import rero.gui.toolbar.ToolAction;

public class GraphicalToolbar
extends JToolBar {
    public static ImageIcon[] images = new ImageIcon[37];
    protected LinkedList tools = new LinkedList();
    private static GraphicalToolbar toolbar = null;
    private static StateListener state;

    public static void startup() {
        state = new StateListener();
        state.propertyChanged("ui.usetoolbar", "");
        ClientState.getClientState().addClientStateListener("ui.usetoolbar", state);
    }

    public static void stateChanged() {
        if (toolbar != null) {
            toolbar.refresh();
        }
    }

    public void refresh() {
        Iterator i = this.tools.iterator();
        while (i.hasNext()) {
            ((ToolButton)i.next()).displayIcon();
        }
    }

    public GraphicalToolbar() {
        int x;
        ToolAction[] actions;
        int[] tiles;
        if (ClientState.getClientState().isOption("ui.sdi", ClientDefaults.ui_sdi)) {
            tiles = new int[]{0, -1, 4, 7, -1, 10, -1, 22, 23, 24, -1, 26, 28, -1, 35, 36};
            actions = new ToolAction[]{new ConnectAction(), null, new OptionsAction(), new ScriptAction(), null, new ListAction(), null, new SendAction(), new ChatAction(), new DCCAction(), null, new NotifyAction(), new NotifyAction2(), null, new HelpAction(), new AboutAction(), new EvilAction()};
        } else {
            tiles = new int[]{0, -1, 4, 7, -1, 10, -1, 22, 23, 24, -1, 26, 28, -1, 31, 32, -1, 35, 36};
            actions = new ToolAction[]{new ConnectAction(), null, new OptionsAction(), new ScriptAction(), null, new ListAction(), null, new SendAction(), new ChatAction(), new DCCAction(), null, new NotifyAction(), new NotifyAction2(), null, new CascadeAction(), new TileAction(), null, new HelpAction(), new AboutAction(), new EvilAction()};
        }
        BufferedImage all = GraphicalToolbar.LoadToolbarImage();
        for (x = 0; x < 37; ++x) {
            GraphicalToolbar.images[x] = new ImageIcon(all.getSubimage(x * 16, 0, 16, 16));
        }
        for (x = 0; x < actions.length; ++x) {
            if (actions[x] == null) {
                this.addSeparator(new Dimension(12, 12));
                continue;
            }
            ToolButton temp = new ToolButton(actions[x]);
            this.add(temp);
            this.tools.add(temp);
        }
        this.setFloatable(false);
        this.setBorderPainted(true);
    }

    private static BufferedImage LoadToolbarImage() {
        ImageIcon original = ClientState.getClientState().getIcon("jirc.toolbar", "toolbar.gif");
        Image image = original.getImage();
        BufferedImage value = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics g = value.getGraphics();
        g.drawImage(image, 0, 0, null);
        original.getImage().flush();
        return value;
    }

    private static class ToolButton
    extends JLabel {
        private ImageIcon normal;
        private ImageIcon pressed;
        private ToolAction action;

        public ToolButton(ToolAction taction) {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.addMouseListener(new Listeners());
            this.action = taction;
            this.displayIcon();
        }

        public void displayIcon() {
            this.normal = images[this.action.getIndex()];
            this.pressed = new ImageIcon(GrayFilter.createDisabledImage(this.normal.getImage()));
            this.setToolTipText(this.action.getDescription());
            this.setIcon(this.normal);
        }

        private class Listeners
        extends MouseAdapter {
            private Listeners() {
            }

            public void mouseClicked(MouseEvent ev) {
                ToolButton.this.action.actionPerformed(ev);
            }

            public void mousePressed(MouseEvent ev) {
                ToolButton.this.setIcon(ToolButton.this.pressed);
            }

            public void mouseReleased(MouseEvent ev) {
                ToolButton.this.setIcon(ToolButton.this.normal);
            }
        }
    }

    private static class StateListener
    implements ClientStateListener {
        private StateListener() {
        }

        public void propertyChanged(String property, String parameter) {
            if (toolbar != null) {
                SessionManager.getGlobalCapabilities().getFrame().getContentPane().remove(toolbar);
            }
            if (ClientState.getClientState().isOption("ui.usetoolbar", true)) {
                if (toolbar == null) {
                    toolbar = new GraphicalToolbar();
                }
                SessionManager.getGlobalCapabilities().getFrame().getContentPane().add((Component)toolbar, "North");
            }
            if (toolbar != null) {
                SessionManager.getGlobalCapabilities().getFrame().getContentPane().validate();
            }
        }
    }
}

