/*
 * Decompiled with CFR 0.152.
 */
package rero.gui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.IRCSession;
import rero.net.SocketInformation;
import rero.util.ClientUtils;
import rero.util.StringUtils;

public class BuiltInLogger {
    protected static boolean isEnabled = ClientState.getClientState().isOption("log.enabled", false);
    protected static boolean timeStamp = ClientState.getClientState().isOption("log.timestamp", true);
    protected static boolean stripColors = ClientState.getClientState().isOption("log.strip", true);
    protected static HashMap logHandles = new HashMap();
    protected static ClientStateListener listener = null;
    protected SocketInformation socket = null;
    protected IRCSession client = null;

    public BuiltInLogger(IRCSession _client) {
        this.client = _client;
        if (listener == null) {
            listener = new LoggerPropListener();
            ClientState.getClientState().addClientStateListener("log.enabled", listener);
            ClientState.getClientState().addClientStateListener("log.timestamp", listener);
            ClientState.getClientState().addClientStateListener("log.strip", listener);
            ClientState.getClientState().addClientStateListener("log.saveto", listener);
        }
    }

    public void logMessage(String window, String text) {
        try {
            PrintWriter writer;
            if (this.socket == null && this.client.getCapabilities() != null && this.client.getCapabilities().getSocketConnection() != null) {
                this.socket = this.client.getCapabilities().getSocketConnection().getSocketInformation();
            }
            if ((writer = this.getFileHandle(this.socket, window)) != null) {
                if (stripColors) {
                    text = StringUtils.strip(text);
                }
                if (timeStamp) {
                    text = ClientUtils.TimeDateStamp(ClientUtils.ctime()) + " " + text;
                }
                writer.println(text);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isEnabled() {
        return isEnabled;
    }

    public static String getLogFileName(SocketInformation socket, String window) {
        String server = "Unknown";
        if (socket != null && socket.network != null && socket.network.length() > 0) {
            server = socket.network;
        }
        if (window.length() == 0) {
            window = "%STATUS%";
        }
        if (window.charAt(0) == '=') {
            server = "dcc_chat";
            window = window.substring(1, window.length());
        }
        File logDir = new File(ClientState.getClientState().getString("log.saveto", ClientDefaults.log_saveto));
        logDir = new File(logDir, server);
        String filename = window.replaceAll("[^\\w\\#\\!\\$\\(\\)\\@\\^\\`\\{\\}\\']", "_");
        File output = new File(logDir, filename + ".log");
        return output.getAbsolutePath();
    }

    private PrintWriter getFileHandle(SocketInformation socket, String window) {
        String server = "Unknown";
        if (socket != null && socket.network != null && socket.network.length() > 0) {
            server = socket.network;
        }
        if (window.length() == 0) {
            window = "%STATUS%";
        }
        if (window.charAt(0) == '=') {
            server = "dcc_chat";
            window = window.substring(1, window.length());
        }
        if (logHandles.containsKey(server + window)) {
            return (PrintWriter)logHandles.get(server + window);
        }
        try {
            File logDir = new File(ClientState.getClientState().getString("log.saveto", ClientDefaults.log_saveto));
            logDir = new File(logDir, server);
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            String filename = window.replaceAll("[^\\w\\#\\!\\$\\(\\)\\@\\^\\`\\{\\}\\']", "_");
            File output = new File(logDir, filename + ".log");
            PrintWriter rv = new PrintWriter(new FileOutputStream(output, true), true);
            logHandles.put(server + window, rv);
            return rv;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static class LoggerPropListener
    implements ClientStateListener {
        private LoggerPropListener() {
        }

        public void propertyChanged(String prop, String parm) {
            if (prop.equals("log.enabled")) {
                isEnabled = ClientState.getClientState().isOption("log.enabled", false);
            }
            if (prop.equals("log.saveto")) {
                Iterator i = logHandles.values().iterator();
                while (i.hasNext()) {
                    PrintWriter temp = (PrintWriter)i.next();
                    try {
                        temp.flush();
                        temp.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                logHandles.clear();
            }
            timeStamp = ClientState.getClientState().isOption("log.timestamp", true);
            stripColors = ClientState.getClientState().isOption("log.strip", true);
        }
    }
}

