/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs.server;

import java.util.ArrayList;
import java.util.Iterator;
import rero.dialogs.server.Server;

public class ServerGroup
implements Comparable {
    protected String name;
    protected ArrayList servers;
    protected int number;

    public ServerGroup(String n) {
        this(n, new ArrayList());
    }

    public void setNumber(int x) {
        this.number = x;
    }

    public int getNumber() {
        return this.number;
    }

    public ServerGroup(String n, ArrayList _servers) {
        this.name = n;
        this.servers = _servers;
    }

    public void clear() {
        this.servers.clear();
    }

    public Server getServerByName(String name) {
        Iterator i = this.servers.iterator();
        while (i.hasNext()) {
            Server temp = (Server)i.next();
            if (!temp.getHost().equals(name)) continue;
            return temp;
        }
        return null;
    }

    public ArrayList getServers() {
        return this.servers;
    }

    public String getName() {
        return this.name;
    }

    public void addServer(Server server) {
        this.servers.add(server);
    }

    public void removeServer(Server server) {
        this.servers.remove(server);
    }

    public String toString() {
        return this.name;
    }

    public boolean isValid() {
        return !this.servers.isEmpty();
    }

    public int compareTo(Object o) {
        ServerGroup arg = (ServerGroup)o;
        return this.name.toUpperCase().compareTo(arg.getName().toUpperCase());
    }
}

