/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs.server;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import rero.config.ClientState;
import rero.dialogs.server.Server;
import rero.dialogs.server.ServerGroup;

public class ServerData {
    protected static ServerData data = null;
    protected ServerGroup allServers = new ServerGroup("All Servers");
    protected ServerGroup randomServers = new ServerGroup("Random Servers");
    protected TreeMap groups = new TreeMap();
    protected ArrayList groupModel = new ArrayList();
    protected ServerGroup active;

    protected ServerData() {
        this.load();
    }

    public Server getServerByName(String host) {
        return this.allServers.getServerByName(host);
    }

    public static ServerData getServerData() {
        if (data == null) {
            data = new ServerData();
        }
        return data;
    }

    public void setActive(ServerGroup a) {
        this.active = a;
        if (this.active == this.allServers || this.active == null) {
            this.buildGroupList();
            return;
        }
        this.active.clear();
        this.groups.clear();
        this.randomServers.clear();
        if (this.active != this.randomServers) {
            this.active = this.getGroup(this.active.getName());
        }
        Iterator i = this.allServers.getServers().iterator();
        while (i.hasNext()) {
            Server temp = (Server)i.next();
            this.getGroup(temp.getNetwork()).addServer(temp);
        }
        this.buildGroupList();
    }

    public void update() {
        this.setActive(this.active);
    }

    public ArrayList getGroups() {
        return this.groupModel;
    }

    public ArrayList getAllServers() {
        return this.allServers.getServers();
    }

    public ArrayList getServers() {
        if (this.active != null) {
            return this.active.getServers();
        }
        return this.allServers.getServers();
    }

    public ServerGroup getGroup(String name) {
        if (name.length() <= 2) {
            return this.randomServers;
        }
        ServerGroup temp = (ServerGroup)this.groups.get(name.toUpperCase());
        if (temp == null) {
            temp = new ServerGroup(name);
            this.groups.put(name.toUpperCase(), temp);
        }
        return temp;
    }

    public void addServer(Server server) {
        this.getGroup(server.getNetwork()).addServer(server);
        this.allServers.addServer(server);
    }

    public void sort() {
        Collections.sort(this.allServers.getServers());
    }

    public void removeServer(Server server) {
        this.allServers.removeServer(server);
        this.getGroup(server.getNetwork()).removeServer(server);
    }

    public void buildGroupList() {
        this.groupModel.clear();
        this.groupModel.add(this.allServers);
        this.allServers.setNumber(0);
        this.groupModel.add(this.randomServers);
        this.randomServers.setNumber(1);
        int x = 2;
        Iterator i = this.groups.values().iterator();
        while (i.hasNext()) {
            ServerGroup temp = (ServerGroup)i.next();
            if (!temp.isValid()) continue;
            this.groupModel.add(temp);
            temp.setNumber(x);
            ++x;
        }
    }

    public void load() {
        this.groups.clear();
        this.allServers = new ServerGroup("All Servers");
        this.randomServers = new ServerGroup("Random Servers");
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(ClientState.getClientState().getResourceAsStream("servers.ini")));
            String data = in.readLine();
            while (data != null) {
                Server temp = Server.decode(data);
                if (temp != null) {
                    this.addServer(temp);
                }
                data = in.readLine();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setActive(this.allServers);
        this.buildGroupList();
    }

    public void save() {
        try {
            ClientState.getClientState();
            PrintWriter out = new PrintWriter(new FileOutputStream(ClientState.getFile("servers.ini"), false));
            int x = 0;
            out.println("; Who thinks mIRC sucks?");
            out.println("[servers]");
            Iterator i = this.allServers.getServers().iterator();
            while (i.hasNext()) {
                Server temp = (Server)i.next();
                out.println(temp.toString(x));
                ++x;
            }
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ServerData temp = new ServerData();
        temp.load();
    }
}

