/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs.server;

import java.util.regex.Pattern;
import rero.util.StringParser;

public class Server
implements Comparable {
    protected static Pattern isServerPassword = Pattern.compile("(\\S)\\S*=(.*)SERVER:(.*):(.*):(.*)GROUP:(.*)");
    protected static Pattern isServerNormal = Pattern.compile("(\\S)\\S*=(.*)SERVER:(.*):(.*)GROUP:(.*)");
    protected String description;
    protected String host;
    protected String portRange;
    protected String network;
    protected boolean isSSL;
    protected String password;
    protected String compare;

    public void setValues(String d, String h, String r, String n, boolean s, String p) {
        this.description = d;
        this.host = h;
        this.portRange = r;
        this.network = n;
        this.isSSL = s;
        this.password = p;
        this.compare = n.toUpperCase() + this.host.toUpperCase();
    }

    public Server() {
    }

    public Server(String d, String h, String r, String n, boolean s, String p) {
        this.setValues(d, h, r, n, s, p);
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean isRandom() {
        return this.getNetwork() == null || this.getNetwork().length() <= 2;
    }

    public String getCompare() {
        return this.compare;
    }

    public int compareTo(Object o) {
        Server arg = (Server)o;
        return this.getCompare().compareTo(arg.getCompare());
    }

    public String getPassword() {
        return this.password;
    }

    public String getPorts() {
        return this.portRange;
    }

    public String getHost() {
        return this.host;
    }

    public String getConnectPort() {
        String myPort = this.portRange;
        if (myPort.indexOf("-") > -1) {
            myPort = myPort.substring(0, myPort.indexOf("-"));
        }
        if (myPort.indexOf(",") > -1) {
            myPort = myPort.substring(0, myPort.indexOf(","));
        }
        return myPort.trim();
    }

    public boolean isSecure() {
        return this.isSSL;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getCommand() {
        StringBuffer command = new StringBuffer("/server ");
        if (this.isSecure()) {
            command.append("-ssl ");
        }
        if (this.getPassword() != null && this.getPassword().length() > 0) {
            command.append("-pass ");
            command.append(this.getPassword());
            command.append(" ");
        }
        command.append(this.getHost());
        command.append(" ");
        command.append(this.getConnectPort());
        return command.toString();
    }

    public String toString(int x) {
        StringBuffer value = new StringBuffer();
        if (this.isSSL) {
            value.append('s');
        } else {
            value.append('n');
        }
        value.append(x);
        value.append('=');
        value.append(this.description);
        value.append("SERVER:");
        value.append(this.host);
        value.append(":");
        value.append(this.portRange);
        if (this.password != null && this.password.length() > 0) {
            value.append(":");
            value.append(this.password);
        }
        value.append("GROUP:");
        value.append(this.network);
        return value.toString();
    }

    public static Server decode(String text) {
        StringParser check = new StringParser(text, isServerPassword);
        if (check.matches()) {
            String[] values = check.getParsedStrings();
            boolean secure = values[0].charAt(0) == 's';
            return new Server(values[1], values[2], values[3], values[5], secure, values[4]);
        }
        check = new StringParser(text, isServerNormal);
        if (check.matches()) {
            String[] values = check.getParsedStrings();
            boolean secure = values[0].charAt(0) == 's';
            return new Server(values[1], values[2], values[3], values[4], secure, null);
        }
        return null;
    }
}

