/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs.help;

import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import rero.config.ClientState;
import rero.dialogs.help.HelperObject;

public class HelpNormal
extends HelperObject
implements TreeSelectionListener {
    private static HashMap helpData = new HashMap();
    protected String lastKey = "";

    public void valueChanged(TreeSelectionEvent e) {
        JTree theTree = (JTree)e.getSource();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)theTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.showHelpOn(node.getUserObject().toString());
    }

    public void showHelpOn(String key) {
        if (HelpNormal.isTutorial(key)) {
            if (this.lastKey.equals("IRC Tutorial")) {
                this.help.scrollTo(helpData.get(key).toString());
            } else {
                this.help.updateText(this.getHelpFor("IRC Tutorial"));
            }
        } else if (HelpNormal.isScriptTutorial(key)) {
            if (this.lastKey.equals("Script Tutorial")) {
                this.help.scrollTo(helpData.get(key).toString());
            } else {
                this.help.updateText(this.getHelpFor("Script Tutorial"));
            }
        } else {
            this.updateText(this.getHelpFor(key));
        }
    }

    private String getHelpFor(String key) {
        this.lastKey = key;
        if (helpData.get(key) == null) {
            String text = ClientState.getClientState().getHelpString(key);
            if (text != null) {
                helpData.put(key, text);
                return text;
            }
            return null;
        }
        String data = helpData.get(key).toString();
        return data;
    }

    private static boolean isTutorial(String key) {
        return key.equals("Introduction") || key.equals("Chatting") || key.equals("Beyond Basics");
    }

    private static boolean isScriptTutorial(String key) {
        return key.equals("Aliases") || key.equals("Events") || key.equals("Resources") || key.equals("Introduction ");
    }

    private DefaultMutableTreeNode initHelp() {
        DefaultMutableTreeNode items = new DefaultMutableTreeNode("Help");
        DefaultMutableTreeNode category = new DefaultMutableTreeNode("About");
        items.add(category);
        DefaultMutableTreeNode option = new DefaultMutableTreeNode("Contributors");
        category.add(option);
        category = new DefaultMutableTreeNode("General");
        items.add(category);
        option = new DefaultMutableTreeNode("Colored Text");
        category.add(option);
        option = new DefaultMutableTreeNode("KB Shortcuts");
        category.add(option);
        category = new DefaultMutableTreeNode("Script Tutorial");
        items.add(category);
        option = new DefaultMutableTreeNode("Introduction ");
        category.add(option);
        option = new DefaultMutableTreeNode("Aliases");
        category.add(option);
        option = new DefaultMutableTreeNode("Events");
        category.add(option);
        option = new DefaultMutableTreeNode("Resources");
        category.add(option);
        helpData.put("Introduction", "part1");
        helpData.put("Chatting", "part2");
        helpData.put("Beyond Basics", "part3");
        helpData.put("Introduction ", "part1");
        helpData.put("Aliases", "part2");
        helpData.put("Events", "part3");
        helpData.put("Resources", "part4");
        return items;
    }

    public JComponent getNavigationComponent() {
        JTree genOptions = new JTree(this.initHelp());
        genOptions.setRootVisible(false);
        genOptions.setToggleClickCount(0);
        genOptions.getSelectionModel().setSelectionMode(0);
        for (int x = 0; x < genOptions.getRowCount(); ++x) {
            genOptions.expandPath(genOptions.getPathForRow(x));
        }
        genOptions.addTreeSelectionListener(this);
        return genOptions;
    }
}

