/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs.help;

import java.util.Iterator;
import java.util.LinkedList;

public class HelpCommand {
    protected String command = "";
    protected String description;
    protected String example;
    protected LinkedList parms = new LinkedList();
    protected LinkedList descs = new LinkedList();
    protected String[] data;

    public HelpCommand(String[] _data) {
        this.data = _data;
    }

    public void init() {
        if (this.command.length() == this.data[0].length()) {
            return;
        }
        this.command = this.data[0];
        this.example = this.data[1];
        this.description = this.data[2];
        for (int x = 3; x < this.data.length; ++x) {
            String[] temp = this.data[x].split("\\s\\-\\s");
            if (temp[0].charAt(0) == '+') {
                this.parms.add("[" + temp[0].substring(1, temp[0].length()) + "]");
            } else {
                this.parms.add("&lt;" + temp[0] + "&gt;");
            }
            this.descs.add(temp[1]);
        }
    }

    public String toString() {
        this.init();
        StringBuffer returnValue = new StringBuffer();
        returnValue.append("<b><font color=\"#000099\">/");
        returnValue.append(this.command);
        returnValue.append("</b>");
        Iterator i = this.parms.iterator();
        while (i.hasNext()) {
            returnValue.append(" ");
            returnValue.append(i.next().toString());
        }
        returnValue.append("<br><br>");
        returnValue.append(this.description);
        if (this.parms.size() > 0) {
            returnValue.append("<br><br><b><font color=\"#333333\">Parameters:</font></b>");
        }
        i = this.parms.iterator();
        Iterator j = this.descs.iterator();
        while (i.hasNext() && j.hasNext()) {
            returnValue.append("<br>");
            returnValue.append(i.next().toString());
            returnValue.append(" - ");
            returnValue.append(j.next().toString());
        }
        returnValue.append("<br><br><b><font color=\"#333333\">Example:</font></b>\n<br>");
        returnValue.append(this.example);
        return returnValue.toString();
    }
}

