/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rero.config.ClientState;
import rero.dck.DMain;
import rero.dialogs.DialogUtilities;
import rero.gui.SessionManager;
import rero.util.ClientUtils;

public class ThemeDialog
extends DMain
implements ActionListener {
    private JLabel label;
    private JButton importt;
    private JButton exportt;

    public String getTitle() {
        return "Theme Manager";
    }

    public String getDescription() {
        return "Theme Manager";
    }

    public void actionPerformed(ActionEvent ev) {
        String name;
        File file = null;
        if (ev.getSource() == this.importt) {
            file = DialogUtilities.showFileDialog("Import Theme File", null, null);
            if (file != null) {
                SessionManager.getGlobalCapabilities().getActiveSession().executeCommand("/theme " + file.getAbsolutePath());
            }
        } else if (ev.getSource() == this.exportt && (name = ClientUtils.generateThemeScript(null)) != null) {
            ClientState.getClientState().setString("current.theme", name);
        }
    }

    public void setupDialog() {
        this.label = new JLabel();
        this.refresh();
        this.importt = new JButton("Import Theme");
        this.importt.setMnemonic('I');
        this.importt.setToolTipText("Import colormap settings from a jIRCii theme script");
        this.importt.addActionListener(this);
        this.exportt = new JButton("Export Theme");
        this.exportt.setMnemonic('E');
        this.exportt.setToolTipText("Export colormap settings to a jIRCii theme script");
        this.exportt.addActionListener(this);
        JPanel a = new JPanel();
        a.setLayout(new FlowLayout(0));
        a.add(this.importt);
        JPanel b = new JPanel();
        b.setLayout(new FlowLayout(0));
        b.add(this.exportt);
        this.addBlankSpace();
        this.addBlankSpace();
        this.addBlankSpace();
        this.addBlankSpace();
        this.addComponent(this.label);
        this.addBlankSpace();
        this.addComponent(a);
        this.addComponent(b);
        this.addBlankSpace();
        this.addLabel("jIRCii themes consist of colormap and background color settings.  To edit the current colormap simply hold down shift and click on text within the client.", 30);
        this.addBlankSpace();
        this.addBlankSpace();
    }

    public void refresh() {
        this.label.setText("Current Theme: " + ClientState.getClientState().getString("current.theme", "jIRCii Default"));
    }
}

