/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import rero.config.ClientState;
import rero.dck.DCapabilities;
import rero.dck.DMain;
import rero.dialogs.AutoWindowDialog;
import rero.dialogs.ClientOptions;
import rero.dialogs.DCCOptions;
import rero.dialogs.ExternalDialog;
import rero.dialogs.FontDialog;
import rero.dialogs.IRCOptions;
import rero.dialogs.IdentDialog;
import rero.dialogs.IgnoreDialog;
import rero.dialogs.ImageDialog;
import rero.dialogs.LoggingDialog;
import rero.dialogs.NotifyDialog;
import rero.dialogs.PerformDialog;
import rero.dialogs.ProxyDialog;
import rero.dialogs.ScriptDialog;
import rero.dialogs.SetupDialog;
import rero.dialogs.SwitchBarDialog;
import rero.dialogs.ThemeDialog;
import rero.dialogs.UIDialog;
import rero.dialogs.WindowsDialog;
import rero.gui.KeyBindings;

public class OptionWindow
extends JDialog
implements DCapabilities,
TreeSelectionListener {
    private static OptionWindow dialog;
    JPanel content;
    JLabel title;
    HashMap dialogs;
    DefaultMutableTreeNode items;
    public DMain current;
    private static Frame frame;

    public void forceSave() {
        if (this.current != null) {
            this.current.save();
            ClientState.getClientState().sync();
        }
    }

    public void refresh() {
        if (this.current != null) {
            this.current.refresh();
        }
    }

    public void closeDialog() {
        KeyBindings.is_dialog_active = false;
        this.setVisible(false);
    }

    public void saveCurrent(DMain newDialog) {
        if (this.current != null) {
            this.current.save();
            ClientState.getClientState().sync();
        }
        this.current = newDialog;
    }

    public static void displaySpecificDialog(String name) {
        dialog.displayDialog(name);
    }

    public void displayDialog(String name) {
        if (this.dialogs.containsKey(name)) {
            this.changeDialogs((DMain)this.dialogs.get(name));
        }
    }

    public String addDialog(DMain dialog) {
        this.dialogs.put(dialog.getTitle(), dialog);
        dialog.installCapabilities(this);
        return dialog.getTitle();
    }

    public void buildTables() {
        this.dialogs = new HashMap();
        this.items = new DefaultMutableTreeNode("Options");
        this.current = new SetupDialog();
        DefaultMutableTreeNode category = new DefaultMutableTreeNode("Setup");
        this.items.add(category);
        DefaultMutableTreeNode option = new DefaultMutableTreeNode(this.addDialog(this.current));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new IdentDialog()));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new ProxyDialog()));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new PerformDialog()));
        category.add(option);
        category = new DefaultMutableTreeNode("Client Options");
        this.items.add(category);
        option = new DefaultMutableTreeNode(this.addDialog(new IRCOptions()));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new ClientOptions()));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new DCCOptions()));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new LoggingDialog()));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new AutoWindowDialog()));
        category.add(option);
        category = new DefaultMutableTreeNode("Scripts");
        this.items.add(category);
        option = new DefaultMutableTreeNode(this.addDialog(new ScriptDialog()));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new ThemeDialog()));
        category.add(option);
        category = new DefaultMutableTreeNode("User Lists");
        this.items.add(category);
        option = new DefaultMutableTreeNode(this.addDialog(new NotifyDialog()));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new IgnoreDialog()));
        category.add(option);
        category = new DefaultMutableTreeNode("Interface Options");
        this.items.add(category);
        option = new DefaultMutableTreeNode(this.addDialog(new UIDialog()));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new FontDialog()));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new SwitchBarDialog()));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new WindowsDialog()));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new ImageDialog()));
        category.add(option);
        option = new DefaultMutableTreeNode(this.addDialog(new ExternalDialog()));
        category.add(option);
    }

    public void valueChanged(TreeSelectionEvent e) {
        JTree theTree = (JTree)e.getSource();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)theTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        DMain temp = (DMain)this.dialogs.get(node.getUserObject());
        this.changeDialogs(temp);
    }

    private void changeDialogs(DMain temp) {
        if (temp == null) {
            return;
        }
        this.title.setText(temp.getDescription());
        this.saveCurrent(temp);
        this.content.removeAll();
        this.content.add((Component)temp.getDialog(), "Center");
        temp.refresh();
        this.content.revalidate();
        this.content.repaint();
    }

    public static void initialize(Component comp) {
        if (JOptionPane.getFrameForComponent(comp) != frame) {
            frame = JOptionPane.getFrameForComponent(comp);
            dialog = new OptionWindow(frame);
        }
    }

    public static String showDialog(Component comp) {
        KeyBindings.is_dialog_active = true;
        dialog.setLocationRelativeTo(comp);
        dialog.setVisible(true);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                KeyBindings.is_dialog_active = false;
            }
        });
        dialog.refresh();
        return "";
    }

    private OptionWindow(Frame frame) {
        super(frame, "jIRCii Options", false);
        this.buildTables();
        JButton closeButton = new JButton("OK");
        closeButton.setMnemonic('O');
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMnemonic('C');
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionWindow.this.forceSave();
                dialog.setVisible(false);
                KeyBindings.is_dialog_active = false;
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                dialog = null;
                frame = null;
                KeyBindings.is_dialog_active = false;
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout(5, 5));
        main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)main, "Center");
        JPanel general = new JPanel();
        general.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel left = new JPanel();
        left.setBorder(BorderFactory.createEtchedBorder());
        left.setPreferredSize(new Dimension(165, 295));
        left.setLayout(new BorderLayout());
        left.add((Component)general, "Center");
        JTree genOptions = new JTree(this.items);
        genOptions.setRootVisible(false);
        genOptions.setToggleClickCount(1);
        genOptions.getSelectionModel().setSelectionMode(0);
        for (int x = 0; x < genOptions.getRowCount(); ++x) {
            genOptions.expandPath(genOptions.getPathForRow(x));
        }
        genOptions.addTreeSelectionListener(this);
        JScrollPane genScroller = new JScrollPane(genOptions);
        genScroller.setVerticalScrollBarPolicy(20);
        genScroller.setHorizontalScrollBarPolicy(31);
        general.setLayout(new BorderLayout(5, 5));
        general.add((Component)new JLabel("Options:"), "North");
        general.add((Component)genScroller, "Center");
        JPanel center = new JPanel();
        center.setLayout(new BorderLayout(5, 5));
        JPanel titlep = new JPanel();
        this.title = new JLabel("Configuration");
        titlep.add((Component)this.title, "Center");
        titlep.setBorder(BorderFactory.createEtchedBorder());
        center.add((Component)titlep, "North");
        this.content = new JPanel();
        this.content.setLayout(new BorderLayout());
        this.content.setBorder(BorderFactory.createEtchedBorder());
        center.add((Component)this.content, "Center");
        this.content.add((Component)this.current.getDialog(), "Center");
        JPanel south = new JPanel();
        south.setLayout(new BorderLayout(5, 5));
        JPanel evil = new JPanel();
        GridLayout gl = new GridLayout(1, 3);
        gl.setHgap(5);
        evil.setLayout(gl);
        evil.add(closeButton);
        evil.add(cancelButton);
        south.add((Component)evil, "East");
        south.add((Component)new JPanel(), "Center");
        main.add((Component)left, "West");
        main.add((Component)center, "Center");
        main.add((Component)south, "South");
        this.pack();
        this.setSize(new Dimension(520, 400));
    }
}

