/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import rero.config.ClientState;
import rero.dck.DMain;
import rero.dck.DParent;
import rero.dck.DTab;
import rero.dck.items.ImageInput;
import rero.dck.items.ImagePreview;
import rero.dck.items.NormalInput;
import rero.dck.items.SelectInput;
import rero.dck.items.TabbedInput;

public class ImageDialog
extends DMain
implements DParent,
ActionListener {
    protected String current = "desktop";
    protected TabbedInput tabs;
    protected ImagePreview preview;
    protected NormalInput label;

    protected void setupLabel() {
        this.label.setText("<html><b><u>" + this.current.substring(0, 1).toUpperCase() + this.current.substring(1, this.current.length()) + "</u></b>: background properties</html>");
    }

    public void actionPerformed(ActionEvent ev) {
        this.tabs.save();
        this.current = ev.getActionCommand();
        this.setupLabel();
        this.tabs.refresh();
        this.preview.refresh();
        this.preview.repaint();
    }

    public String getTitle() {
        return "Backgrounds";
    }

    public void notifyParent(String variable) {
        ClientState.getClientState().fireChange(this.current);
        this.preview.repaint();
        if (variable.equals(this.current + ".bgtype")) {
            this.tabs.refresh();
        }
    }

    public String getVariable(String variable) {
        return this.current + "." + variable;
    }

    public String getDescription() {
        return "Client Background Images";
    }

    public void setupDialog() {
        this.addBlankSpace();
        this.preview = (ImagePreview)this.addOther(new ImagePreview(35, 115));
        this.label = this.addLabelNormal("Editing Statusbar Options", 5);
        this.setupLabel();
        this.tabs = this.addTabbedInput();
        this.tabs.addTab(new BackgroundSetup());
        this.tabs.addTab(new EditColor());
        this.tabs.addTab(new TransformImage());
        this.tabs.addTab(new EditTint());
        this.tabs.setParent(this);
        this.preview.addActionListener(this);
    }

    protected class BackgroundSetup
    extends DTab {
        private DefaultComboBoxModel desktop = new DefaultComboBoxModel<String>(new String[]{"Default", "Solid Color", "           ", "Image"});
        private DefaultComboBoxModel statusbar = new DefaultComboBoxModel<String>(new String[]{"Default", "Solid Color", "Transparent", "Image"});
        private DefaultComboBoxModel window = new DefaultComboBoxModel<String>(new String[]{"       ", "Solid Color", "           ", "Image"});
        private SelectInput selector;

        protected BackgroundSetup() {
        }

        public void refresh() {
            if (ImageDialog.this.current.equals("statusbar")) {
                this.selector.setModel(this.statusbar);
            }
            if (ImageDialog.this.current.equals("desktop")) {
                this.selector.setModel(this.desktop);
            }
            if (ImageDialog.this.current.equals("window")) {
                this.selector.setModel(this.window);
            }
            super.refresh();
        }

        public String getTitle() {
            return "Type";
        }

        public String getDescription() {
            return "Choose background options for the component";
        }

        public void setupDialog() {
            this.selector = this.addSelectInput("bgtype", 0, new String[]{"Default", "Solid Color", "Transparent", "Image"}, "Type of background:  ", 'T', 0);
        }
    }

    protected class TransformImage
    extends DTab {
        protected TransformImage() {
        }

        public String getTitle() {
            return "Transform";
        }

        public boolean isEnabled() {
            return ClientState.getClientState().getInteger(ImageDialog.this.current + ".bgtype", 0) == 3;
        }

        public String getDescription() {
            return "Options for selected background image";
        }

        public void setupDialog() {
            this.addSelectInput("bgstyle", 0, new String[]{"Tile", "Center", "Fill", "Stretch"}, "Transform Image: ", 'T', 25);
            this.addCheckboxInput("relative", false, "Align image with desktop", 'A');
        }
    }

    protected class EditColor
    extends DTab {
        protected EditColor() {
        }

        public String getTitle() {
            return "Setup";
        }

        public boolean isEnabled() {
            return ClientState.getClientState().getInteger(ImageDialog.this.current + ".bgtype", 0) != 0;
        }

        public String getDescription() {
            return "Select color and image for background";
        }

        public void setupDialog() {
            this.addOther(new ImageInput("image", "", "Background Image: ", 'I'));
            this.addColorInput("color", Color.black, "Select Background Color", 'c');
        }
    }

    protected class EditTint
    extends DTab {
        protected EditTint() {
        }

        public String getTitle() {
            return "Tint";
        }

        public boolean isEnabled() {
            int type = ClientState.getClientState().getInteger(ImageDialog.this.current + ".bgtype", 0);
            return type == 2 || type == 3;
        }

        public String getDescription() {
            return "Adjust transparency settings";
        }

        public void setupDialog() {
            this.addFloatInput("tint", 0.0f, "Alpha Tint: ");
        }
    }
}

