/*
 * Decompiled with CFR 0.152.
 */
package rero.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.dialogs.help.HelpCommands;
import rero.dialogs.help.HelpData;
import rero.dialogs.help.HelpNormal;
import rero.gui.KeyBindings;

public class HelpWindow
extends JDialog
implements HyperlinkListener {
    private static HelpWindow dialog;
    private static HashMap helpData;
    private static HelpData commandData;
    private JEditorPane display;
    private JScrollPane scroller;
    private static Frame frame;

    public static LinkedList getBuiltInAliases() {
        if (commandData == null) {
            commandData = new HelpData();
        }
        return commandData.getAliases();
    }

    public static HelpData getCommandData() {
        return commandData;
    }

    public String getCommand(String key) {
        return commandData.getCommand(key).toString();
    }

    public void scrollTo(String ref) {
        this.display.scrollToReference(ref);
    }

    public void updateText(String text) {
        this.display.setText(text);
        this.display.setCaretPosition(0);
    }

    public static void initialize(Component comp) {
        if (JOptionPane.getFrameForComponent(comp) != frame) {
            frame = JOptionPane.getFrameForComponent(comp);
            dialog = new HelpWindow(frame);
        }
    }

    public static String showDialog(Component comp) {
        KeyBindings.is_dialog_active = true;
        dialog.setLocationRelativeTo(comp);
        dialog.setVisible(true);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                KeyBindings.is_dialog_active = false;
            }
        });
        return "";
    }

    private HelpWindow(Frame frame) {
        super(frame, "jIRCii Help", false);
        if (commandData == null) {
            commandData = new HelpData();
        }
        JButton closeButton = new JButton("Ok");
        closeButton.setMnemonic('O');
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                KeyBindings.is_dialog_active = false;
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout(5, 5));
        main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)main, "Center");
        HelpNormal general = new HelpNormal();
        general.setHelp(this);
        HelpCommands commands = new HelpCommands();
        commands.setHelp(this);
        JTabbedPane left = new JTabbedPane();
        left.addTab("Help", null, general.getNavigation(), "detailed information.");
        left.addTab("Commands", null, commands.getNavigation(), "jIRCii command reference.");
        left.setSelectedIndex(0);
        left.setPreferredSize(new Dimension(175, 295));
        JPanel center = new JPanel();
        center.setLayout(new BorderLayout(5, 5));
        JPanel space = new JPanel();
        space.setPreferredSize(new Dimension(0, 15));
        center.add((Component)space, "North");
        this.display = new JTextPane();
        this.display.setEditable(false);
        this.display.setContentType("text/html");
        this.display.setOpaque(true);
        this.display.setBackground(Color.white);
        this.display.addHyperlinkListener(this);
        this.scroller = new JScrollPane(this.display);
        this.scroller.setVerticalScrollBarPolicy(22);
        this.scroller.setPreferredSize(new Dimension(250, 250));
        center.add((Component)this.scroller, "Center");
        JPanel south = new JPanel();
        south.setLayout(new BorderLayout(5, 5));
        south.add((Component)closeButton, "East");
        south.add((Component)new JPanel(), "Center");
        main.add((Component)left, "West");
        main.add((Component)center, "Center");
        main.add((Component)south, "South");
        this.pack();
        this.setSize(new Dimension(600, 363));
        general.showHelpOn("About");
    }

    public void hyperlinkUpdate(HyperlinkEvent ev) {
        if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                if (ev.getURL().getRef() != null) {
                    this.display.scrollToReference(ev.getURL().getRef());
                } else {
                    Runtime.getRuntime().exec(ClientState.getClientState().getString("ui.openfiles", ClientDefaults.ui_openfiles) + " " + ev.getURL().toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        helpData = new HashMap();
    }
}

