/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import rero.dck.DContainer;
import rero.dck.DItem;
import rero.dck.DParent;
import rero.dck.DTab;

public class TabbedInput
extends JPanel
implements DItem {
    protected LinkedList items = new LinkedList();
    protected JTabbedPane tabs;

    public TabbedInput() {
        this.setLayout(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.add((Component)this.tabs, "Center");
    }

    public void addTab(DTab item) {
        this.tabs.addTab(item.getTitle(), null, item.getDialog(), item.getDescription());
        this.items.add(item);
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, (int)super.getPreferredSize().getHeight());
    }

    public void setEnabled(boolean b) {
        Iterator i = this.items.iterator();
        while (i.hasNext()) {
            ((DContainer)i.next()).setEnabled(b);
        }
        this.tabs.setEnabled(b);
    }

    public void save() {
        Iterator i = this.items.iterator();
        while (i.hasNext()) {
            ((DContainer)i.next()).save();
        }
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int width) {
    }

    public void setParent(DParent parent) {
        Iterator i = this.items.iterator();
        while (i.hasNext()) {
            ((DContainer)i.next()).setParent(parent);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        int count = 0;
        Iterator i = this.items.iterator();
        while (i.hasNext()) {
            DTab item = (DTab)i.next();
            item.refresh();
            this.tabs.setEnabledAt(count, item.isEnabled());
            item.setEnabled(item.isEnabled());
            ++count;
        }
    }
}

