/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rero.config.ClientState;
import rero.dck.SuperInput;

public class StringInput
extends SuperInput {
    protected JLabel label;
    protected String value;
    protected JTextField text;

    public StringInput(String var, String _value, String _label, int rightGap, char mnemonic) {
        this.label = new JLabel(_label);
        this.setLayout(new BorderLayout());
        this.text = new JTextField();
        this.add((Component)this.label, "West");
        this.add((Component)this.text, "Center");
        if (rightGap > 0) {
            JPanel temp = new JPanel();
            temp.setPreferredSize(new Dimension(rightGap, 0));
            this.add((Component)temp, "East");
        }
        this.label.setDisplayedMnemonic(mnemonic);
        this.variable = var;
        this.value = _value;
    }

    public void save() {
        ClientState.getClientState().setString(this.getVariable(), this.text.getText());
    }

    public int getEstimatedWidth() {
        return (int)this.label.getPreferredSize().getWidth();
    }

    public void setAlignWidth(int width) {
        this.label.setPreferredSize(new Dimension(width, 0));
        this.revalidate();
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        this.text.setText(ClientState.getClientState().getString(this.getVariable(), this.value));
    }
}

