/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import rero.config.ClientState;
import rero.config.StringList;
import rero.dck.DCapabilities;
import rero.dck.DItem;
import rero.dck.DParent;
import rero.dialogs.server.Server;
import rero.dialogs.server.ServerData;
import rero.dialogs.server.ServerGroup;
import rero.dialogs.toolkit.ADialog;
import rero.dialogs.toolkit.APanel;
import rero.dialogs.toolkit.LabelGroup;
import rero.gui.SessionManager;

public class ServerList
extends JPanel
implements DItem {
    protected int height;
    protected int width;
    protected JButton connect;
    protected JButton edit;
    protected JComboBox network;
    protected JList list;
    protected ServerData data;
    protected StringList autoConnect;
    protected JComponent component;
    protected DCapabilities capabilities;

    public ServerList(ServerData _data, int _width, int _height, DCapabilities _capabilities) {
        this.data = _data;
        this.autoConnect = ClientState.getClientState().getStringList("auto.connect");
        this.capabilities = _capabilities;
        this.width = _width;
        this.height = _height;
        this.component = this;
        this.setBorder(BorderFactory.createEmptyBorder(0, this.width, 0, this.width));
        this.setLayout(new BorderLayout());
        this.connect = new JButton("Connect");
        this.connect.setMnemonic('C');
        this.edit = new JButton("Edit");
        this.edit.setMnemonic('E');
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(1));
        buttons.add(this.connect);
        buttons.add(this.edit);
        this.network = new JComboBox(new NetworkListModel());
        this.network.setPrototypeDisplayValue("Random Servers");
        buttons.add(this.network);
        this.edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ServerEditorDialog temp = new ServerEditorDialog(ServerList.this.component);
                temp.getListbox().setSelectedIndex(ServerList.this.list.getSelectedIndex());
                temp.getListbox().ensureIndexIsVisible(ServerList.this.list.getSelectedIndex());
                temp.showDialog(ServerList.this.component);
                ServerList.this.data.update();
                ((ServerListModel)ServerList.this.list.getModel()).fireChange();
                ((NetworkListModel)ServerList.this.network.getModel()).fireChange();
            }
        });
        this.network.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ServerList.this.data.setActive((ServerGroup)ServerList.this.network.getSelectedItem());
                ((ServerListModel)ServerList.this.list.getModel()).fireChange();
            }
        });
        this.connect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ServerList.this.handleConnectAction();
            }
        });
        this.add((Component)buttons, "South");
        ServerListModel lmodel = new ServerListModel();
        this.list = new JList(lmodel);
        this.list.setCellRenderer(lmodel);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent ev) {
                if (ev.getClickCount() >= 2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ServerList.this.handleConnectAction();
                        }
                    });
                    ev.consume();
                }
            }
        });
        this.add((Component)new JScrollPane(this.list, 22, 30), "Center");
        this.setPreferredSize(new Dimension(0, this.height));
    }

    public void handleConnectAction() {
        this.capabilities.forceSave();
        if (SessionManager.getGlobalCapabilities().getActiveSession().getCapabilities().isConnected()) {
            SessionManager.getGlobalCapabilities().createNewServer();
        }
        Server connectToMe = (Server)this.list.getSelectedValue();
        SessionManager.getGlobalCapabilities().getActiveSession().executeCommand(connectToMe.getCommand());
        this.capabilities.closeDialog();
    }

    public void setParent(DParent parent) {
    }

    public void setEnabled(boolean b) {
    }

    public void save() {
        if (this.network.getSelectedItem() != null) {
            ClientState.getClientState().setInteger("sdialog.selected", ((ServerGroup)this.network.getSelectedItem()).getNumber());
        }
        this.data.save();
    }

    public void refresh() {
        try {
            this.network.setSelectedIndex(ClientState.getClientState().getInteger("sdialog.selected", 0));
            this.data.update();
            ((ServerListModel)this.list.getModel()).fireChange();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int width) {
    }

    public void setParentVariable(String parent) {
    }

    public JComponent getComponent() {
        return this;
    }

    protected class EditServerInfo
    extends APanel {
        protected JTextField description = new JTextField();
        protected JTextField host = new JTextField();
        protected JTextField portRange = new JTextField();
        protected JTextField network = new JTextField();
        protected JCheckBox isSSL = new JCheckBox("Server requires SSL");
        protected JCheckBox isStartup = new JCheckBox("Connect to server on client startup");
        protected JPasswordField password = new JPasswordField();

        protected EditServerInfo() {
        }

        public void setupDialog(Object value) {
            if (value == null) {
                this.setBorder(BorderFactory.createTitledBorder(" Create New Server "));
            } else {
                this.setBorder(BorderFactory.createTitledBorder(" Edit Server Information "));
            }
            LabelGroup labels = new LabelGroup();
            JLabel description_l = new JLabel(" Description: ");
            JLabel host_l = new JLabel(" Hostname: ");
            JLabel portRange_l = new JLabel(" Port(s): ");
            JLabel network_l = new JLabel(" Network: ");
            JLabel password_l = new JLabel(" Password: ");
            labels.addLabel(description_l);
            labels.addLabel(host_l);
            labels.addLabel(portRange_l);
            labels.addLabel(network_l);
            labels.addLabel(password_l);
            this.addComponent(EditServerInfo.mergeComponents(description_l, this.description, 20));
            this.addComponent(EditServerInfo.mergeComponents(host_l, this.host, 20));
            this.addComponent(EditServerInfo.mergeComponents(portRange_l, this.portRange, 100));
            this.addComponent(EditServerInfo.mergeComponents(network_l, this.network, 20));
            this.addComponent(this.isSSL);
            this.addComponent(EditServerInfo.mergeComponents(password_l, this.password, 20));
            this.addComponent(this.isStartup);
            labels.sync();
            if (value != null) {
                Server temp = (Server)value;
                this.description.setText(temp.getDescription());
                this.host.setText(temp.getHost());
                this.portRange.setText(temp.getPorts());
                this.network.setText(temp.getNetwork());
                this.isSSL.setSelected(temp.isSecure());
                this.isStartup.setSelected(ServerList.this.autoConnect.isValue(temp.getHost()));
                this.password.setText(temp.getPassword());
            }
        }

        public Object getValue(Object value) {
            Server server = value != null ? (Server)value : new Server();
            if (this.isStartup.isSelected() && !ServerList.this.autoConnect.isValue(this.host.getText())) {
                System.out.println("Adding: " + this.host.getText());
                ServerList.this.autoConnect.add(this.host.getText());
                ServerList.this.autoConnect.save();
            } else if (!this.isStartup.isSelected() && ServerList.this.autoConnect.isValue(this.host.getText())) {
                System.out.println("Removing: " + this.host.getText());
                ServerList.this.autoConnect.remove(this.host.getText());
                ServerList.this.autoConnect.save();
            }
            server.setValues(this.description.getText(), this.host.getText(), this.portRange.getText(), this.network.getText(), this.isSSL.isSelected(), this.password.getText());
            return server;
        }
    }

    protected class NetworkListModel
    extends AbstractListModel
    implements ComboBoxModel {
        protected Object selected;

        protected NetworkListModel() {
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public void setSelectedItem(Object item) {
            this.selected = item;
        }

        public void fireChange() {
            this.fireContentsChanged(this, 0, -1);
        }

        public Object getElementAt(int index) {
            return ServerList.this.data.getGroups().get(index);
        }

        public int getSize() {
            return ServerList.this.data.getGroups().size();
        }
    }

    protected class ServerListModel
    extends AbstractListModel
    implements ListCellRenderer {
        protected JLabel cell = new JLabel();

        protected ServerListModel() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Server svalue = (Server)value;
            if (index < 0 || index > this.getSize()) {
                return this.cell;
            }
            this.cell.setToolTipText(svalue.getHost() + ":" + svalue.getPorts());
            Color fore = UIManager.getColor("TextField.foreground");
            if (ServerList.this.autoConnect.isValue(svalue.getHost())) {
                fore = Color.blue;
            }
            if (isSelected) {
                this.cell.setOpaque(true);
                this.cell.setBackground(UIManager.getColor("TextField.selectionBackground"));
                if (fore == Color.blue) {
                    this.cell.setForeground(fore);
                } else {
                    this.cell.setForeground(UIManager.getColor("TextField.selectionForeground"));
                }
                this.cell.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
                if (svalue.getNetwork().length() <= 2) {
                    this.cell.setText("Random: " + svalue.getHost() + ":" + svalue.getPorts());
                } else if (svalue.isSecure()) {
                    this.cell.setText(svalue.getNetwork() + ": " + svalue.getHost() + ":" + svalue.getPorts() + " (SSL)");
                } else {
                    this.cell.setText(svalue.getNetwork() + ": " + svalue.getHost() + ":" + svalue.getPorts());
                }
            } else {
                this.cell.setOpaque(false);
                this.cell.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
                this.cell.setForeground(fore);
                this.cell.setText(svalue.getDescription());
            }
            return this.cell;
        }

        public void fireChange() {
            this.fireContentsChanged(this, 0, -1);
        }

        public Object getElementAt(int index) {
            return ServerList.this.data.getServers().get(index);
        }

        public int getSize() {
            return ServerList.this.data.getServers().size();
        }
    }

    protected class ServerEditorDialog
    extends JDialog {
        protected JList alist;

        public String showDialog(Component comp) {
            this.setLocationRelativeTo(comp);
            this.setVisible(true);
            return "";
        }

        public JList getListbox() {
            return this.alist;
        }

        public ServerEditorDialog(JComponent comp) {
            super(JOptionPane.getFrameForComponent(comp), "Server Editor", true);
            this.getContentPane().setLayout(new BorderLayout());
            ServerListModel lmodel = new ServerListModel();
            this.alist = new JList(lmodel);
            this.alist.setCellRenderer(lmodel);
            JPanel lpanel = new JPanel();
            lpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            lpanel.setLayout(new BorderLayout());
            lpanel.add((Component)new JScrollPane(this.alist, 22, 30), "Center");
            this.getContentPane().add((Component)lpanel, "Center");
            JToolBar buttons = new JToolBar();
            buttons.setFloatable(false);
            buttons.setLayout(new FlowLayout());
            JButton add = new JButton("Add");
            add.setMnemonic('A');
            buttons.add(add);
            JButton edit = new JButton("Edit");
            edit.setMnemonic('E');
            buttons.add(edit);
            JButton remove = new JButton("Remove");
            remove.setMnemonic('R');
            buttons.add(remove);
            buttons.addSeparator();
            JButton sort = new JButton("Sort");
            sort.setMnemonic('S');
            buttons.add(sort);
            buttons.addSeparator();
            JButton ok = new JButton("Close");
            ok.setMnemonic('C');
            buttons.add(ok);
            edit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    EditServerInfo editor = new EditServerInfo();
                    editor.setupDialog(ServerEditorDialog.this.alist.getSelectedValue());
                    ADialog dialog = new ADialog(((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.component, "Edit Server", editor, ServerEditorDialog.this.alist.getSelectedValue());
                    dialog.setSize(new Dimension(330, 280));
                    if (dialog.showDialog(((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.component) != null) {
                        ((ServerListModel)ServerEditorDialog.this.alist.getModel()).fireChange();
                    }
                }
            });
            add.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    EditServerInfo editor = new EditServerInfo();
                    editor.setupDialog(null);
                    ADialog dialog = new ADialog(((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.component, "New Server", editor, null);
                    dialog.setSize(new Dimension(330, 280));
                    Server temp = (Server)dialog.showDialog(((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.component);
                    if (temp != null) {
                        ((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.data.addServer(temp);
                        ((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.data.update();
                        ((ServerListModel)ServerEditorDialog.this.alist.getModel()).fireChange();
                    }
                }
            });
            remove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    if (ServerEditorDialog.this.alist.getSelectedValue() != null) {
                        ((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.data.removeServer((Server)ServerEditorDialog.this.alist.getSelectedValue());
                        ((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.data.update();
                        ((ServerListModel)ServerEditorDialog.this.alist.getModel()).fireChange();
                    }
                }
            });
            sort.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.data.sort();
                    ((ServerEditorDialog)ServerEditorDialog.this).ServerList.this.data.update();
                    ((ServerListModel)ServerEditorDialog.this.alist.getModel()).fireChange();
                }
            });
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ServerEditorDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)buttons, "South");
            this.setSize(400, 200);
        }
    }
}

