/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rero.config.ClientState;
import rero.dck.SuperInput;

public class SelectInput
extends SuperInput
implements ItemListener {
    protected JLabel label;
    protected int defaultVal;
    protected JComboBox select;

    public SelectInput(String var, int _defaultVal, String[] values, String _label, char mnemonic, int rightGap) {
        this.label = new JLabel(_label);
        this.setLayout(new BorderLayout());
        this.select = new JComboBox<String>(values);
        this.add((Component)this.label, "West");
        this.add((Component)this.select, "Center");
        if (rightGap > 0) {
            JPanel temp = new JPanel();
            temp.setPreferredSize(new Dimension(rightGap, 0));
            this.add((Component)temp, "East");
        }
        this.label.setDisplayedMnemonic(mnemonic);
        this.select.addItemListener(this);
        this.variable = var;
        this.defaultVal = _defaultVal;
    }

    public void setEnabled(boolean b) {
        Component[] blah = this.getComponents();
        for (int x = 0; x < blah.length; ++x) {
            blah[x].setEnabled(b);
        }
        super.setEnabled(b);
    }

    public void setModel(ComboBoxModel model) {
        this.select.setModel(model);
    }

    public void save() {
        ClientState.getClientState().setInteger(this.getVariable(), this.select.getSelectedIndex());
    }

    public int getEstimatedWidth() {
        return (int)this.label.getPreferredSize().getWidth();
    }

    public void setAlignWidth(int width) {
        this.label.setPreferredSize(new Dimension(width, 0));
        this.revalidate();
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        this.select.setSelectedIndex(ClientState.getClientState().getInteger(this.getVariable(), this.defaultVal));
    }

    public void itemStateChanged(ItemEvent ev) {
        this.notifyParent();
    }
}

