/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rero.config.ClientState;
import rero.dck.SuperInput;

public class OptionInput
extends SuperInput
implements ItemListener {
    protected JLabel label;
    protected String defaultVal;
    protected JComboBox select;

    public OptionInput(String var, String _defaultVal, String[] values, String _label, char mnemonic, int rightGap) {
        this.label = new JLabel(_label);
        this.setLayout(new BorderLayout());
        this.select = new JComboBox<String>(values);
        this.select.setEditable(true);
        this.add((Component)this.label, "West");
        this.add((Component)this.select, "Center");
        if (rightGap > 0) {
            JPanel temp = new JPanel();
            temp.setPreferredSize(new Dimension(rightGap, 0));
            this.add((Component)temp, "East");
        }
        this.label.setDisplayedMnemonic(mnemonic);
        this.select.addItemListener(this);
        this.variable = var;
        this.defaultVal = _defaultVal;
    }

    public void setEnabled(boolean b) {
        Component[] blah = this.getComponents();
        for (int x = 0; x < blah.length; ++x) {
            blah[x].setEnabled(b);
        }
        super.setEnabled(b);
    }

    public void save() {
        ClientState.getClientState().setString(this.getVariable(), this.select.getSelectedItem().toString());
    }

    public int getEstimatedWidth() {
        return (int)this.label.getPreferredSize().getWidth();
    }

    public void setAlignWidth(int width) {
        this.label.setPreferredSize(new Dimension(width, 0));
        this.revalidate();
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        this.select.setSelectedItem(ClientState.getClientState().getString(this.getVariable(), this.defaultVal));
    }

    public void itemStateChanged(ItemEvent ev) {
        this.notifyParent();
    }
}

