/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rero.config.ClientState;
import rero.config.StringList;
import rero.dck.SuperInput;
import rero.dialogs.server.ServerData;
import rero.dialogs.server.ServerGroup;
import rero.dialogs.toolkit.ADialog;
import rero.dialogs.toolkit.APanel;

public class NetworkSelect
extends SuperInput
implements ItemListener {
    public static final String ALL_NETWORKS = "All Networks";
    protected JComboBox networks;
    protected JButton add;
    protected JButton delete;
    protected String networkV;
    protected String currentV;
    protected StringList data;
    protected LinkedList listeners = new LinkedList();

    public NetworkSelect(String _variableNetworks, String _variableCurrent) {
        this.networkV = _variableNetworks;
        this.currentV = _variableCurrent;
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(" Network:"), "North");
        this.networks = new JComboBox();
        this.networks.setPrototypeDisplayValue("SuperLamerNet");
        this.networks.addItemListener(this);
        JPanel bottom = new JPanel();
        bottom.setLayout(new FlowLayout(0));
        bottom.add(this.networks);
        this.add = new JButton("Add");
        this.add.setMnemonic('A');
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                NetworkSelect.this.showNetworkDialog();
            }
        });
        this.delete = new JButton("Delete");
        this.delete.setMnemonic('D');
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (NetworkSelect.this.networks.getSelectedIndex() > 0) {
                    ClientState.getClientState().setString(NetworkSelect.this.getVariable(), "");
                    ClientState.getClientState().sync();
                    int zz = NetworkSelect.this.networks.getSelectedIndex() - 1;
                    NetworkSelect.this.data.remove(NetworkSelect.this.networks.getSelectedItem().toString());
                    NetworkSelect.this.refresh();
                    NetworkSelect.this.networks.setSelectedIndex(zz);
                }
            }
        });
        bottom.add(this.add);
        bottom.add(this.delete);
        this.add((Component)bottom, "Center");
    }

    public void showNetworkDialog() {
        NetworkPanel panel = new NetworkPanel();
        panel.setupDialog(null);
        ADialog temp = new ADialog(this, "Select a network", panel, null);
        temp.pack();
        String network = (String)temp.showDialog(null);
        if (network != null && !this.data.isValue(network)) {
            this.data.add(network);
            this.refresh();
            this.networks.setSelectedIndex(this.networks.getItemCount() - 1);
        }
    }

    public void save() {
        if (this.data != null) {
            this.data.save();
        }
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int width) {
    }

    public void itemStateChanged(ItemEvent ev) {
        if (ev.getStateChange() == 1) {
            this.fireEvent(this.networks.getSelectedItem().toString());
            this.notifyParent();
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        this.networks.removeAllItems();
        this.networks.addItem(ALL_NETWORKS);
        if (this.data == null) {
            this.data = ClientState.getClientState().getStringList(this.networkV);
        }
        LinkedList temp = this.data.getList();
        Iterator i = temp.iterator();
        while (i.hasNext()) {
            this.networks.addItem(i.next().toString());
        }
        this.networks.setSelectedIndex(0);
    }

    protected void fireEvent(String command) {
        ActionEvent ev = new ActionEvent(this, 0, command);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ActionListener temp = (ActionListener)i.next();
            temp.actionPerformed(ev);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void addDeleteListener(ActionListener l) {
        this.delete.addActionListener(l);
    }

    protected static class NetworkPanel
    extends APanel {
        private JList list;

        protected NetworkPanel() {
        }

        public void setupDialog(Object value) {
            DefaultListModel<String> model = new DefaultListModel<String>();
            Iterator i = ServerData.getServerData().getGroups().iterator();
            i.next();
            i.next();
            while (i.hasNext()) {
                ServerGroup group = (ServerGroup)i.next();
                model.addElement(group.getName());
            }
            this.list = new JList(model);
            this.addComponent(new JLabel("Select a network:"));
            this.addComponent(new JScrollPane(this.list));
        }

        public void processParent(final ADialog dialog) {
            this.list.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent ev) {
                    if (ev.getClickCount() > 1) {
                        dialog.closeAndReturn();
                    }
                }
            });
        }

        public Object getValue(Object value) {
            return this.list.getSelectedValue();
        }
    }
}

