/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rero.config.ClientState;
import rero.config.StringList;
import rero.dck.SuperInput;

public class ListInput
extends SuperInput
implements ActionListener {
    protected InputListModel model;
    protected JList list;
    protected StringList data;
    protected String desc;
    protected String title;

    public ListInput(String variable, String _title, String _desc, int width, int height) {
        this.title = _title;
        this.desc = _desc;
        this.setLayout(new BorderLayout());
        this.data = ClientState.getClientState().getStringList(variable);
        this.data.load();
        this.model = new InputListModel();
        this.list = new JList(this.model);
        JPanel temp = new JPanel();
        temp.setPreferredSize(new Dimension(width, height));
        this.add((Component)temp, "East");
        temp = new JPanel();
        temp.setPreferredSize(new Dimension(width, height));
        this.add((Component)temp, "West");
        this.add((Component)new JScrollPane(this.list), "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(1));
        JButton addme = new JButton("Add");
        addme.setMnemonic('A');
        addme.addActionListener(this);
        buttons.add(addme);
        JButton remme = new JButton("Remove");
        remme.setMnemonic('R');
        remme.addActionListener(this);
        buttons.add(remme);
        this.add((Component)buttons, "South");
        this.setMinimumSize(new Dimension(width, height));
    }

    public void save() {
        this.data.save();
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int width) {
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        this.data.load();
        this.model.fireChange();
    }

    public void actionPerformed(ActionEvent ev) {
        String input;
        if (ev.getActionCommand().equals("Remove") && this.list.getSelectedIndex() >= 0) {
            this.data.getList().remove(this.list.getSelectedIndex());
            this.model.fireChange();
        }
        if (ev.getActionCommand().equals("Add") && (input = JOptionPane.showInputDialog(this, this.title, this.desc, 3)) != null) {
            this.data.getList().add(input);
            this.model.fireChange();
        }
        this.notifyParent();
    }

    protected class InputListModel
    extends AbstractListModel {
        protected InputListModel() {
        }

        public void fireChange() {
            ListInput.this.model.fireContentsChanged(ListInput.this.model, 0, ListInput.this.model.getSize());
        }

        public Object getElementAt(int index) {
            return (String)ListInput.this.data.getList().get(index);
        }

        public int getSize() {
            return ListInput.this.data.getList().size();
        }
    }
}

