/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rero.dck.DItem;
import rero.dck.DParent;
import rero.gui.background.BackgroundDesktop;
import rero.gui.background.BackgroundPanel;
import rero.gui.background.BackgroundToolBar;

public class ImagePreview
extends JPanel
implements DItem {
    protected ImageConfigPreview preview;
    protected JLabel evil;
    protected int height;
    protected int width;
    protected LinkedList listeners = new LinkedList();

    public ImagePreview(int _width, int _height) {
        this.width = _width;
        this.height = _height;
        this.setBorder(BorderFactory.createEmptyBorder(0, this.width, 0, this.width));
        this.setLayout(new GridLayout(1, 1));
        this.preview = new ImageConfigPreview();
        this.add(this.preview);
    }

    public void setParent(DParent parent) {
    }

    public void setEnabled(boolean b) {
    }

    public void save() {
    }

    public void refresh() {
        this.preview.center();
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int width) {
    }

    public void setParentVariable(String parent) {
    }

    public JComponent getComponent() {
        return this;
    }

    protected void fireEvent(String command) {
        ActionEvent ev = new ActionEvent(this, 0, command);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ActionListener temp = (ActionListener)i.next();
            temp.actionPerformed(ev);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    protected class ImageConfigPreview
    extends JPanel {
        protected BackgroundPanel window;
        protected JPanel wparent;
        protected JDesktopPane desktop;
        protected BackgroundToolBar toolbar;

        public ImageConfigPreview() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEtchedBorder());
            this.desktop = new JDesktopPane();
            BackgroundDesktop wallpaper = new BackgroundDesktop(this.desktop);
            wallpaper.setSize(Toolkit.getDefaultToolkit().getScreenSize());
            this.desktop.add((Component)wallpaper, new Integer(Integer.MIN_VALUE));
            this.add((Component)this.desktop, "Center");
            this.window = new BackgroundPanel();
            this.window.setLayout(new BorderLayout());
            JPanel bottom = new JPanel();
            bottom.setLayout(new BorderLayout());
            bottom.setPreferredSize(new Dimension(0, 30));
            bottom.setOpaque(false);
            this.toolbar = new BackgroundToolBar();
            this.toolbar.setPreferredSize(new Dimension(0, 15));
            this.toolbar.setFloatable(false);
            bottom.add((Component)this.toolbar, "North");
            this.window.add((Component)bottom, "South");
            this.wparent = new JPanel();
            this.wparent.setLayout(new BorderLayout());
            this.wparent.setBorder(BorderFactory.createEtchedBorder());
            this.wparent.add((Component)this.window, "Center");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ImageConfigPreview.this.desktop.add(ImageConfigPreview.this.wparent);
                    ImageConfigPreview.this.center();
                    ImageConfigPreview.this.validate();
                }
            });
            PreviewMouseListener listener = new PreviewMouseListener();
            this.window.addMouseListener(listener);
            this.toolbar.addMouseListener(listener);
            this.desktop.addMouseListener(listener);
        }

        public void center() {
            int dw = this.desktop.getBounds().width;
            int dh = this.desktop.getBounds().height;
            int width = dw - 40;
            int height = dh - 40;
            int x = 20;
            int y = 20;
            this.wparent.setBounds(x, y, width, height);
        }

        public Dimension getPreferredSize() {
            return new Dimension(0, ImagePreview.this.height);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        protected class PreviewMouseListener
        extends MouseAdapter {
            protected PreviewMouseListener() {
            }

            public void mousePressed(MouseEvent ev) {
                if (ev.getSource() == ImageConfigPreview.this.window) {
                    ImagePreview.this.fireEvent("window");
                } else if (ev.getSource() == ImageConfigPreview.this.toolbar) {
                    ImagePreview.this.fireEvent("statusbar");
                } else if (ev.getSource() == ImageConfigPreview.this.desktop) {
                    ImagePreview.this.fireEvent("desktop");
                }
            }
        }
    }
}

