/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import rero.config.ClientState;
import rero.dck.SmallButton;
import rero.dck.SuperInput;

public class ImageInput
extends SuperInput
implements ActionListener {
    protected JLabel label;
    protected JTextField text;
    protected SmallButton button;
    protected String value;
    protected JFileChooser chooser;
    protected boolean directory;

    public ImageInput(String _variable, String _value, String _label, char mnemonic) {
        this.label = new JLabel(_label);
        this.text = new JTextField();
        this.button = new SmallButton(this.text.getBorder(), "Click to open an image chooser dialog");
        this.button.addActionListener(this);
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)this.label, "West");
        this.add((Component)this.text, "Center");
        this.add((Component)this.button, "East");
        this.label.setLabelFor(this.button);
        this.label.setDisplayedMnemonic(mnemonic);
        this.variable = _variable;
        this.value = _value;
    }

    public void actionPerformed(ActionEvent ev) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setApproveButtonText("Select Image");
            this.chooser.addChoosableFileFilter(new ImageFilter());
            this.chooser.setAccessory(new ImagePreview(this.chooser));
        }
        if (this.chooser.showDialog(this, null) == 0) {
            this.text.setText(this.chooser.getSelectedFile().getAbsolutePath());
            this.text.requestFocus();
        }
        this.notifyParent();
    }

    public void save() {
        ClientState.getClientState().setString(this.getVariable(), this.text.getText());
    }

    public int getEstimatedWidth() {
        return (int)this.label.getPreferredSize().getWidth();
    }

    public void setAlignWidth(int width) {
        this.label.setPreferredSize(new Dimension(width, 0));
        this.revalidate();
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        this.text.setText(ClientState.getClientState().getString(this.getVariable(), this.value));
    }

    protected static class ImageFilter
    extends FileFilter {
        protected static HashSet extensions = new HashSet();

        protected ImageFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String file = f.getName();
            if (file.lastIndexOf(46) > -1) {
                String ext = file.substring(file.lastIndexOf(46), file.length()).toLowerCase();
                return extensions.contains(ext);
            }
            return false;
        }

        public String getDescription() {
            return "Image Files";
        }

        static {
            extensions.add(".png");
            extensions.add(".tif");
            extensions.add(".tiff");
            extensions.add(".gif");
            extensions.add(".jpg");
            extensions.add(".jpeg");
        }
    }

    protected class ImagePreview
    extends JPanel
    implements PropertyChangeListener {
        protected ImageIcon thumbnail = null;
        protected File file = null;
        protected JLabel label;

        public ImagePreview(JFileChooser fc) {
            this.setBorder(ImageInput.this.text.getBorder());
            this.setPreferredSize(new Dimension(150, 75));
            fc.addPropertyChangeListener(this);
        }

        public void loadImage() {
            if (this.file == null) {
                return;
            }
            ImageIcon tmpIcon = new ImageIcon(this.file.getPath());
            if (tmpIcon.getIconWidth() > this.getWidth() - 5) {
                this.thumbnail = new ImageIcon(tmpIcon.getImage().getScaledInstance(this.getWidth() - 10, -1, 1));
                if (this.thumbnail.getIconHeight() > this.getHeight() - 5) {
                    this.thumbnail = new ImageIcon(this.thumbnail.getImage().getScaledInstance(-1, this.getHeight() - 10, 1));
                }
            } else {
                this.thumbnail = tmpIcon;
            }
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.thumbnail == null) {
                this.loadImage();
            }
            if (this.thumbnail != null) {
                int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
                int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
                if (y < 0) {
                    y = 0;
                }
                if (x < 5) {
                    x = 5;
                }
                this.thumbnail.paintIcon(this, g, x, y);
            }
            this.paintBorder(g);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("SelectedFileChangedProperty")) {
                this.file = (File)e.getNewValue();
                if (this.isShowing()) {
                    this.loadImage();
                    this.repaint();
                }
            }
        }
    }
}

