/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rero.config.ClientState;
import rero.dck.SuperInput;

public class FontInput
extends SuperInput
implements ItemListener {
    protected JComboBox name;
    protected JComboBox style;
    protected JComboBox size;
    protected JLabel preview;
    protected Font value;
    protected boolean listing = true;

    public static String funny() {
        String[] taglines = new String[]{"The quick brown fox jumped over the lazy coder", "Fat butane, grubbin' on French fries", "Sun sucks!@"};
        int r = (int)System.currentTimeMillis() / 1000 % taglines.length;
        return taglines[Math.abs(r)];
    }

    public FontInput(String _variable, Font _value) {
        this.variable = _variable;
        this.value = _value;
        this.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        JPanel fonts = new JPanel();
        fonts.setLayout(new FlowLayout(1));
        this.name = new JComboBox();
        this.name.setPrototypeDisplayValue("Times New Roman.");
        this.name.addItem("Loading fonts...");
        this.style = new JComboBox<String>(new String[]{"Plain", "Italic", "Bold"});
        this.size = new JComboBox<String>(new String[]{"5", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "20", "22", "26", "32"});
        this.name.addItemListener(this);
        this.style.addItemListener(this);
        this.size.addItemListener(this);
        fonts.add(this.name);
        fonts.add(this.style);
        fonts.add(this.size);
        top.add((Component)fonts, "Center");
        this.preview = new JLabel(FontInput.funny());
        this.preview.setOpaque(false);
        JPanel bottom = new JPanel();
        bottom.setLayout(new FlowLayout(1));
        bottom.add(this.preview);
        this.add((Component)top, "North");
        this.add((Component)bottom, "Center");
    }

    public void save() {
        ClientState.getClientState().setFont(this.getVariable(), this.preview.getFont());
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int width) {
    }

    public void itemStateChanged(ItemEvent ev) {
        Font f = Font.decode(this.name.getSelectedItem() + "-" + this.style.getSelectedItem().toString().toUpperCase() + "-" + this.size.getSelectedItem());
        this.preview.setFont(f);
        this.preview.revalidate();
        this.notifyParent();
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        if (!this.listing) {
            Font f = ClientState.getClientState().getFont(this.getVariable(), this.value);
            this.name.setSelectedItem(f.getFamily());
            this.size.setSelectedItem(f.getSize() + "");
            if (f.isBold()) {
                this.style.setSelectedItem("Bold");
            } else if (f.isItalic()) {
                this.style.setSelectedItem("Italic");
            } else {
                this.style.setSelectedItem("Plain");
            }
            this.preview.setFont(f);
            this.preview.validate();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                    for (int x = 0; x < fonts.length; ++x) {
                        FontInput.this.name.addItem(fonts[x]);
                    }
                    FontInput.this.name.removeItemAt(0);
                    FontInput.this.listing = false;
                    FontInput.this.refresh();
                    FontInput.this.revalidate();
                }
            });
        }
    }
}

