/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rero.config.ClientState;
import rero.config.StringList;
import rero.dck.SuperInput;

public class FileListInput
extends SuperInput
implements ActionListener,
ListSelectionListener {
    protected InputListModel model;
    protected JList list;
    protected StringList data;
    protected JTextField fullPath;
    protected JButton addme;
    protected JButton remme;
    protected String desc;
    protected JFileChooser chooser;

    public FileListInput(String variable, String _desc, String add, char mn1, String rem, char mn2, int width, int height) {
        this.desc = _desc;
        this.setLayout(new BorderLayout());
        this.data = ClientState.getClientState().getStringList(variable);
        this.data.load();
        this.model = new InputListModel();
        this.list = new JList(this.model);
        JPanel temp = new JPanel();
        temp.setPreferredSize(new Dimension(width, height));
        this.add((Component)temp, "East");
        temp = new JPanel();
        temp.setPreferredSize(new Dimension(width, height));
        this.add((Component)temp, "West");
        this.add((Component)new JScrollPane(this.list), "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(1));
        JLabel l_path = new JLabel("Selected:  ");
        this.fullPath = new JTextField("no file selected");
        this.fullPath.setBorder(null);
        this.fullPath.setEditable(false);
        this.fullPath.setOpaque(false);
        JPanel pathDisplay = new JPanel();
        pathDisplay.setLayout(new BorderLayout());
        pathDisplay.add((Component)l_path, "West");
        pathDisplay.add((Component)this.fullPath, "Center");
        pathDisplay.setBorder(BorderFactory.createEmptyBorder(0, width, 0, 0));
        this.addme = new JButton(add);
        this.addme.setMnemonic(mn1);
        this.addme.addActionListener(this);
        buttons.add(this.addme);
        this.remme = new JButton(rem);
        this.remme.setMnemonic(mn2);
        this.remme.addActionListener(this);
        buttons.add(this.remme);
        JPanel evil = new JPanel();
        evil.setLayout(new BorderLayout());
        evil.add((Component)pathDisplay, "North");
        evil.add((Component)buttons, "South");
        this.list.addListSelectionListener(this);
        this.add((Component)evil, "South");
        this.setMinimumSize(new Dimension(width, height));
    }

    public void save() {
        this.data.save();
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void valueChanged(ListSelectionEvent ev) {
        if (!ev.getValueIsAdjusting()) {
            this.setSelectedCaption();
        }
    }

    public void setSelectedCaption() {
        if (this.list.getSelectedIndex() > -1 && this.list.getSelectedIndex() < this.list.getModel().getSize()) {
            this.fullPath.setText(this.data.getList().get(this.list.getSelectedIndex()).toString());
        } else {
            this.fullPath.setText("no file selected");
        }
    }

    public void setAlignWidth(int width) {
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        this.data.load();
        this.model.fireChange();
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.remme && this.list.getSelectedIndex() >= 0) {
            this.data.getList().remove(this.list.getSelectedIndex());
            this.model.fireChange();
        }
        if (ev.getSource() == this.addme) {
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
                this.chooser.setApproveButtonText(this.desc);
            }
            if (this.chooser.showDialog(this, null) == 0) {
                this.data.getList().add(this.chooser.getSelectedFile().getAbsolutePath());
                this.model.fireChange();
            }
        }
        this.setSelectedCaption();
        this.notifyParent();
    }

    protected class InputListModel
    extends AbstractListModel {
        protected InputListModel() {
        }

        public void fireChange() {
            FileListInput.this.model.fireContentsChanged(FileListInput.this.model, 0, FileListInput.this.model.getSize());
        }

        public Object getElementAt(int index) {
            return new File((String)FileListInput.this.data.getList().get(index)).getName();
        }

        public int getSize() {
            return FileListInput.this.data.getList().size();
        }
    }
}

