/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import rero.config.ClientState;
import rero.dck.SuperInput;

public class ColorInput
extends SuperInput
implements ActionListener {
    protected SolidIcon colorIcon;
    protected JButton button;
    protected Color initial;

    public ColorInput(String _variable, Color _initial, String text, char mnemonic) {
        this.setLayout(new FlowLayout(1));
        this.initial = _initial;
        this.variable = _variable;
        this.colorIcon = new SolidIcon(this.initial, 18, 18);
        this.button = new JButton(text, this.colorIcon);
        this.button.setMnemonic(mnemonic);
        this.button.addActionListener(this);
        this.add(this.button);
    }

    public void actionPerformed(ActionEvent ev) {
        Color temp = JColorChooser.showDialog(this.button, "Select color...", this.colorIcon.getColor());
        if (temp != null) {
            this.colorIcon.setColor(temp);
            this.button.repaint();
            this.notifyParent();
        }
    }

    public void save() {
        ClientState.getClientState().setColor(this.getVariable(), this.colorIcon.getColor());
    }

    public void refresh() {
        this.colorIcon.setColor(ClientState.getClientState().getColor(this.getVariable(), this.initial));
        this.button.repaint();
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int width) {
    }

    public JComponent getComponent() {
        return this;
    }

    protected static class SolidIcon
    implements Icon {
        private int width;
        private int height;
        private Color color;

        public SolidIcon(Color c, int w, int h) {
            this.width = w;
            this.height = h;
            this.color = c;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color c) {
            this.color = c;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, this.width - 1, this.height - 1);
        }
    }
}

