/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.FlowLayout;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rero.config.ClientState;
import rero.dck.DItem;
import rero.dck.SuperInput;

public class CheckboxInput
extends SuperInput
implements ChangeListener {
    protected LinkedList enabledTrue = new LinkedList();
    protected LinkedList enabledFalse = new LinkedList();
    protected JCheckBox box;
    protected boolean defaultVal;

    public CheckboxInput(String var, boolean defaultVar, String _label, char mnemonic) {
        this(var, defaultVar, _label, mnemonic, 0);
    }

    public CheckboxInput(String var, boolean defaultVar, String _label, char mnemonic, int alignment) {
        this.setLayout(new FlowLayout(alignment, 0, 0));
        this.box = new JCheckBox(_label);
        this.box.addChangeListener(this);
        this.add(this.box);
        this.box.setMnemonic(mnemonic);
        this.setPreferredSize(this.box.getPreferredSize());
        this.variable = var;
        this.defaultVal = defaultVar;
    }

    public void stateChanged(ChangeEvent ev) {
        this.handleDependents();
        this.notifyParent();
    }

    public void addDependent(DItem item) {
        this.enabledTrue.add(item);
    }

    public void addAntiDependent(DItem item) {
        this.enabledFalse.add(item);
    }

    public void save() {
        ClientState.getClientState().setOption(this.getVariable(), this.box.isSelected());
    }

    public int getEstimatedWidth() {
        return 0;
    }

    public void setAlignWidth(int width) {
    }

    public JComponent getComponent() {
        return this;
    }

    public void refresh() {
        this.box.setSelected(ClientState.getClientState().isOption(this.getVariable(), this.defaultVal));
        this.handleDependents();
    }

    public void handleDependents() {
        DItem temp;
        Iterator i = this.enabledTrue.iterator();
        while (i.hasNext()) {
            temp = (DItem)i.next();
            temp.setEnabled(this.box.isSelected());
        }
        i = this.enabledFalse.iterator();
        while (i.hasNext()) {
            temp = (DItem)i.next();
            temp.setEnabled(!this.box.isSelected());
        }
    }

    public JCheckBox getCheckBox() {
        return this.box;
    }
}

