/*
 * Decompiled with CFR 0.152.
 */
package rero.dck.items;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rero.config.ClientState;
import rero.dck.SuperInput;

public class CharsetInput
extends SuperInput {
    public static final String DEFAULT_CHARSET = "Platform Default";
    protected JComboBox name;
    protected boolean listing = true;
    protected JLabel label;

    public CharsetInput(String _variable, String aLabel, char mnemonic, int rightGap) {
        this.variable = _variable;
        this.setLayout(new BorderLayout());
        this.name = new JComboBox();
        this.name.addItem("Loading Charsets...");
        this.add((Component)this.name, "Center");
        if (rightGap > 0) {
            JPanel temp = new JPanel();
            temp.setPreferredSize(new Dimension(rightGap, 0));
            this.add((Component)temp, "East");
        }
        this.label = new JLabel("  " + aLabel + " ");
        this.label.setDisplayedMnemonic(mnemonic);
        this.add((Component)this.label, "West");
    }

    public void setAlignWidth(int width) {
        this.label.setPreferredSize(new Dimension(width, 0));
        this.revalidate();
    }

    public void save() {
        ClientState.getClientState().setString(this.getVariable(), this.name.getSelectedItem().toString());
    }

    public JComponent getComponent() {
        return this;
    }

    public int getEstimatedWidth() {
        return (int)this.label.getPreferredSize().getWidth();
    }

    public void refresh() {
        if (!this.listing) {
            this.name.setSelectedItem(ClientState.getClientState().getString(this.getVariable(), DEFAULT_CHARSET));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CharsetInput.this.name.addItem(CharsetInput.DEFAULT_CHARSET);
                    Iterator<String> i = Charset.availableCharsets().keySet().iterator();
                    while (i.hasNext()) {
                        CharsetInput.this.name.addItem(i.next().toString());
                    }
                    CharsetInput.this.name.removeItemAt(0);
                    CharsetInput.this.listing = false;
                    CharsetInput.this.refresh();
                    CharsetInput.this.revalidate();
                }
            });
        }
    }
}

