/*
 * Decompiled with CFR 0.152.
 */
package rero.dck;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class FileLink
extends JComponent {
    protected LinkedList listeners;
    protected JComponent label;
    protected String text = "";

    public FileLink() {
        this.addMouseListener(new TakeAction());
        this.listeners = new LinkedList();
        this.label = this;
    }

    public void setText(String _text) {
        this.text = _text;
        this.setToolTipText(this.text);
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, Toolkit.getDefaultToolkit().getFontMetrics(this.getFont()).getHeight());
    }

    public void paint(Graphics g) {
        int x;
        StringBuffer string = new StringBuffer();
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(g.getFont());
        for (x = 0; x < this.text.length() && fm.stringWidth(this.text.substring(0, x)) < this.getWidth(); ++x) {
        }
        if (this.isEnabled()) {
            g.setColor(this.label.getForeground());
            g.drawLine(0, this.getHeight() - fm.getDescent() + 1, fm.stringWidth(this.text.substring(0, x)), this.getHeight() - fm.getDescent() + 1);
        } else {
            g.setColor(this.label.getForeground().brighter());
        }
        g.drawString(this.getText().substring(0, x), 0, this.getHeight() - fm.getDescent());
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void fireEvent() {
        ActionEvent event = new ActionEvent(this, 0, "?");
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ActionListener)i.next()).actionPerformed(event);
        }
    }

    public class TakeAction
    extends MouseAdapter {
        protected Color original;

        public void mouseClicked(MouseEvent ev) {
            if (FileLink.this.isEnabled()) {
                FileLink.this.fireEvent();
            }
        }

        public void mousePressed(MouseEvent ev) {
            if (FileLink.this.isEnabled()) {
                this.original = FileLink.this.label.getForeground();
                FileLink.this.label.setForeground(UIManager.getColor("TextArea.selectionBackground"));
                FileLink.this.label.repaint();
            }
        }

        public void mouseReleased(MouseEvent ev) {
            if (FileLink.this.isEnabled()) {
                FileLink.this.label.setForeground(this.original);
                FileLink.this.label.repaint();
            }
        }

        public void mouseEntered(MouseEvent ev) {
        }

        public void mouseExited(MouseEvent ev) {
            if (FileLink.this.isEnabled()) {
                FileLink.this.label.setForeground(this.original);
                FileLink.this.label.repaint();
            }
        }
    }
}

